/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ALC11
extends ALC10 {
    public static final int ALC_MONO_SOURCES = 4112;
    public static final int ALC_STEREO_SOURCES = 4113;
    public static final int ALC_DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
    public static final int ALC_ALL_DEVICES_SPECIFIER = 4115;
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;

    protected ALC11() {
        throw new UnsupportedOperationException();
    }

    public static long nalcCaptureOpenDevice(long l2, int n2, int n3, int n4) {
        long l3 = ALC.getICD().alcCaptureOpenDevice;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePP(l2, n2, n3, n4, l3);
    }

    public static long alcCaptureOpenDevice(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
        }
        return ALC11.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe(byteBuffer), n2, n3, n4);
    }

    public static long alcCaptureOpenDevice(CharSequence charSequence, int n2, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = ALC11.nalcCaptureOpenDevice(charSequence == null ? 0L : memoryStack.getPointerAddress(), n2, n3, n4);
            return l2;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static boolean alcCaptureCloseDevice(long l2) {
        long l3 = ALC.getICD().alcCaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.invokePZ(l2, l3);
    }

    public static void alcCaptureStart(long l2) {
        long l3 = ALC.getICD().alcCaptureStart;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void alcCaptureStop(long l2) {
        long l3 = ALC.getICD().alcCaptureStop;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nalcCaptureSamples(long l2, long l3, int n2) {
        long l4 = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, n2, l4);
    }

    public static void alcCaptureSamples(long l2, ByteBuffer byteBuffer, int n2) {
        ALC11.nalcCaptureSamples(l2, MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static void alcCaptureSamples(long l2, ShortBuffer shortBuffer, int n2) {
        ALC11.nalcCaptureSamples(l2, MemoryUtil.memAddress(shortBuffer), n2);
    }

    public static void alcCaptureSamples(long l2, IntBuffer intBuffer, int n2) {
        ALC11.nalcCaptureSamples(l2, MemoryUtil.memAddress(intBuffer), n2);
    }

    public static void alcCaptureSamples(long l2, FloatBuffer floatBuffer, int n2) {
        ALC11.nalcCaptureSamples(l2, MemoryUtil.memAddress(floatBuffer), n2);
    }

    public static void alcCaptureSamples(long l2, short[] sArray, int n2) {
        long l3 = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        JNI.invokePPV(l2, sArray, n2, l3);
    }

    public static void alcCaptureSamples(long l2, int[] nArray, int n2) {
        long l3 = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        JNI.invokePPV(l2, nArray, n2, l3);
    }

    public static void alcCaptureSamples(long l2, float[] fArray, int n2) {
        long l3 = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        JNI.invokePPV(l2, fArray, n2, l3);
    }
}

