/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC$ICD;
import org.lwjgl.openal.ALC$ICDStatic;
import org.lwjgl.openal.ALC$SharedLibraryAL;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class ALC {
    private static FunctionProviderLocal functionProvider;
    private static ALCCapabilities router;
    private static final ThreadLocal capabilitiesTLS;
    private static ALC$ICD icd;

    private ALC() {
    }

    public static void create() {
        String string;
        switch (Platform.get()) {
            case LINUX: 
            case MACOSX: {
                string = "openal";
                break;
            }
            case WINDOWS: {
                string = "OpenAL";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ALC.create((String)Configuration.OPENAL_LIBRARY_NAME.get(Platform.mapLibraryNameBundled(string)));
    }

    public static void create(String object) {
        object = Library.loadNative(ALC.class, "org.lwjgl.openal", (String)object, true);
        try {
            ALC.create(new ALC$SharedLibraryAL((SharedLibrary)object));
            return;
        }
        catch (RuntimeException runtimeException) {
            object.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProviderLocal functionProviderLocal) {
        if (functionProvider != null) {
            throw new IllegalStateException("ALC has already been created.");
        }
        functionProvider = functionProviderLocal;
        router = ALC.createCapabilities(0L);
        AL.init();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.destroy();
        router = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    static Object check(Object object) {
        if (object == null) {
            throw new IllegalStateException("OpenAL library has not been loaded.");
        }
        return object;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return (FunctionProviderLocal)ALC.check(functionProvider);
    }

    public static void setCapabilities(ALCCapabilities aLCCapabilities) {
        capabilitiesTLS.set(aLCCapabilities);
        if (icd == null) {
            icd = new ALC$ICDStatic(null);
        }
        icd.set(aLCCapabilities);
    }

    public static ALCCapabilities getCapabilities() {
        ALCCapabilities aLCCapabilities = (ALCCapabilities)capabilitiesTLS.get();
        if (aLCCapabilities == null) {
            aLCCapabilities = router;
        }
        return ALC.checkCapabilities(aLCCapabilities);
    }

    private static ALCCapabilities checkCapabilities(ALCCapabilities aLCCapabilities) {
        if (aLCCapabilities == null) {
            throw new IllegalStateException("No ALCCapabilities instance set");
        }
        return aLCCapabilities;
    }

    public static ALCCapabilities createCapabilities(long l2) {
        return ALC.createCapabilities(l2, null);
    }

    public static ALCCapabilities createCapabilities(long l2, IntFunction intFunction) {
        int n2;
        int n3;
        FunctionProviderLocal functionProviderLocal = ALC.getFunctionProvider();
        long l3 = functionProviderLocal.getFunctionAddress("alcGetIntegerv");
        long l4 = functionProviderLocal.getFunctionAddress("alcGetString");
        long l5 = functionProviderLocal.getFunctionAddress("alcIsExtensionPresent");
        if (l3 == 0L || l4 == 0L || l5 == 0L) {
            throw new IllegalStateException("Core ALC functions could not be found. Make sure that OpenAL has been loaded.");
        }
        Object object = MemoryStack.stackPush();
        Serializable serializable = null;
        try {
            IntBuffer intBuffer = ((MemoryStack)object).mallocInt(1);
            JNI.invokePPV(l2, 4096, 1, MemoryUtil.memAddress(intBuffer), l3);
            n3 = intBuffer.get(0);
            JNI.invokePPV(l2, 4097, 1, MemoryUtil.memAddress(intBuffer), l3);
            n2 = intBuffer.get(0);
            if (object != null) {
                ((MemoryStack)object).close();
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                serializable = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((MemoryStack)object).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)serializable).addSuppressed(throwable4);
                        }
                    } else {
                        ((MemoryStack)object).close();
                    }
                }
                throw throwable3;
            }
        }
        object = new int[][]{{0, 1}};
        serializable = new HashSet(16);
        for (int i2 = 1; i2 <= ((Object)object).length; ++i2) {
            for (Object object2 : object[i2 - 1]) {
                if (i2 >= n3 && (i2 != n3 || object2 > n2)) continue;
                serializable.add("OpenALC" + i2 + (int)object2);
            }
        }
        String string = MemoryUtil.memASCIISafe(JNI.invokePP(l2, 4102, l4));
        if (string != null) {
            Object object3 = new StringTokenizer(string);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object3).nextToken();
                MemoryStack memoryStack = MemoryStack.stackPush();
                Throwable throwable = null;
                try {
                    if (JNI.invokePPZ(l2, MemoryUtil.memAddress(memoryStack.ASCII(string2, true)), l5)) {
                        serializable.add(string2);
                    }
                    if (memoryStack == null) continue;
                    memoryStack.close();
                }
                catch (Throwable throwable5) {
                    try {
                        object3 = throwable5;
                        throwable = throwable5;
                        throw object3;
                    }
                    catch (Throwable throwable6) {
                        if (memoryStack != null) {
                            if (throwable != null) {
                                try {
                                    memoryStack.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                memoryStack.close();
                            }
                        }
                        throw throwable6;
                    }
                }
            }
        }
        APIUtil.apiFilterExtensions((Set)((Object)serializable), Configuration.OPENAL_EXTENSION_FILTER);
        ALCCapabilities aLCCapabilities = new ALCCapabilities(functionProviderLocal, l2, (Set)((Object)serializable), intFunction == null ? BufferUtils::createPointerBuffer : intFunction);
        if (l2 != 0L) {
            ALC.setCapabilities(aLCCapabilities);
        }
        return aLCCapabilities;
    }

    static ALCCapabilities getICD() {
        ALCCapabilities aLCCapabilities = icd == null ? null : icd.get();
        if (aLCCapabilities == null) {
            aLCCapabilities = router;
        }
        return (ALCCapabilities)ALC.check(aLCCapabilities);
    }

    static /* synthetic */ ALC$ICD access$102(ALC$ICD aLC$ICD) {
        icd = aLC$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        if (!((Boolean)Configuration.OPENAL_EXPLICIT_INIT.get(Boolean.FALSE)).booleanValue()) {
            ALC.create();
        }
    }
}

