/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.SharedLibrary$Delegate;

class ALC$SharedLibraryAL
extends SharedLibrary$Delegate
implements FunctionProviderLocal {
    private final long alcGetProcAddress = this.getFunctionAddress("alcGetProcAddress");

    protected ALC$SharedLibraryAL(SharedLibrary sharedLibrary) {
        super(sharedLibrary);
        if (this.alcGetProcAddress == 0L) {
            throw new RuntimeException("A core ALC function is missing. Make sure that the OpenAL library has been loaded correctly.");
        }
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        long l2 = this.library.getFunctionAddress(byteBuffer);
        if (l2 == 0L && Checks.DEBUG_FUNCTIONS) {
            APIUtil.apiLogMissing("ALC core", byteBuffer);
        }
        return l2;
    }

    @Override
    public long getFunctionAddress(long l2, ByteBuffer byteBuffer) {
        long l3 = this.library.getFunctionAddress(byteBuffer);
        if (l3 == 0L && l2 != 0L) {
            l3 = JNI.invokePPP(l2, MemoryUtil.memAddress(byteBuffer), this.alcGetProcAddress);
        }
        if (l3 == 0L && Checks.DEBUG_FUNCTIONS) {
            APIUtil.apiLogMissing("ALC", byteBuffer);
        }
        return l3;
    }
}

