/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL$ICD;
import org.lwjgl.openal.AL$ICDStatic;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class AL {
    private static ALCapabilities processCaps;
    private static final ThreadLocal capabilitiesTLS;
    private static AL$ICD icd;

    private AL() {
    }

    static void init() {
    }

    static void destroy() {
        AL.setCurrentProcess(null);
    }

    public static void setCurrentProcess(ALCapabilities aLCapabilities) {
        processCaps = aLCapabilities;
        capabilitiesTLS.set(null);
        icd.set(aLCapabilities);
    }

    public static void setCurrentThread(ALCapabilities aLCapabilities) {
        capabilitiesTLS.set(aLCapabilities);
        icd.set(aLCapabilities);
    }

    public static ALCapabilities getCapabilities() {
        ALCapabilities aLCapabilities = (ALCapabilities)capabilitiesTLS.get();
        if (aLCapabilities == null) {
            aLCapabilities = processCaps;
        }
        return AL.checkCapabilities(aLCapabilities);
    }

    private static ALCapabilities checkCapabilities(ALCapabilities aLCapabilities) {
        if (aLCapabilities == null) {
            throw new IllegalStateException("No ALCapabilities instance set for the current thread or process. Possible solutions:\n\ta) Call AL.createCapabilities() after making a context current.\n\tb) Call AL.setCurrentProcess() or AL.setCurrentThread() if an ALCapabilities instance already exists.");
        }
        return aLCapabilities;
    }

    public static ALCapabilities createCapabilities(ALCCapabilities aLCCapabilities) {
        return AL.createCapabilities(aLCCapabilities, null);
    }

    public static ALCapabilities createCapabilities(ALCCapabilities object, IntFunction intFunction) {
        long l2 = ALC.getFunctionProvider().getFunctionAddress(0L, "alGetProcAddress");
        if (l2 == 0L) {
            throw new RuntimeException("A core AL function is missing. Make sure that the OpenAL library has been loaded correctly.");
        }
        FunctionProvider functionProvider = byteBuffer -> {
            long l3 = JNI.invokePP(MemoryUtil.memAddress(byteBuffer), l2);
            if (l3 == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLogMissing("AL", byteBuffer);
            }
            return l3;
        };
        long l3 = functionProvider.getFunctionAddress("alGetString");
        long l4 = functionProvider.getFunctionAddress("alGetError");
        long l5 = functionProvider.getFunctionAddress("alIsExtensionPresent");
        if (l3 == 0L || l4 == 0L || l5 == 0L) {
            throw new IllegalStateException("Core OpenAL functions could not be found. Make sure that the OpenAL library has been loaded correctly.");
        }
        Object object2 = MemoryUtil.memASCIISafe(JNI.invokeP(45058, l3));
        if (object2 == null || JNI.invokeI(l4) != 0) {
            throw new IllegalStateException("There is no OpenAL context current in the current thread or process.");
        }
        object2 = APIUtil.apiParseVersion((String)object2);
        int n2 = ((APIUtil$APIVersion)object2).major;
        int n3 = ((APIUtil$APIVersion)object2).minor;
        int[][] nArrayArray = new int[][]{{0, 1}};
        HashSet<String> hashSet = new HashSet<String>(32);
        for (int i2 = 1; i2 <= nArrayArray.length; ++i2) {
            for (int n4 : nArrayArray[i2 - 1]) {
                if (i2 >= n2 && (i2 != n2 || n4 > n3)) continue;
                hashSet.add("OpenAL" + i2 + (int)n4);
            }
        }
        String string = MemoryUtil.memASCIISafe(JNI.invokeP(45060, l3));
        if (string != null) {
            MemoryStack memoryStack = MemoryStack.stackGet();
            Object object3 = new StringTokenizer(string);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object3).nextToken();
                MemoryStack memoryStack2 = memoryStack.push();
                Throwable throwable = null;
                try {
                    if (JNI.invokePZ(MemoryUtil.memAddress(memoryStack2.ASCII(string2, true)), l5)) {
                        hashSet.add(string2);
                    }
                    if (memoryStack2 == null) continue;
                    memoryStack2.close();
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (memoryStack2 != null) {
                            if (throwable != null) {
                                try {
                                    memoryStack2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                memoryStack2.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
        if (((ALCCapabilities)object).ALC_EXT_EFX) {
            hashSet.add("ALC_EXT_EFX");
        }
        APIUtil.apiFilterExtensions(hashSet, Configuration.OPENAL_EXTENSION_FILTER);
        ALCapabilities aLCapabilities = new ALCapabilities(functionProvider, hashSet, intFunction == null ? BufferUtils::createPointerBuffer : intFunction);
        if (((ALCCapabilities)object).ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
            AL.setCurrentThread(aLCapabilities);
        } else {
            AL.setCurrentProcess(aLCapabilities);
        }
        return aLCapabilities;
    }

    static ALCapabilities getICD() {
        return (ALCapabilities)ALC.check(icd.get());
    }

    static /* synthetic */ AL$ICD access$102(AL$ICD aL$ICD) {
        icd = aL$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new AL$ICDStatic(null);
    }
}

