/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.glfw.GLFWNativeX11$Functions;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLFWNativeX11 {
    protected GLFWNativeX11() {
        throw new UnsupportedOperationException();
    }

    public static long glfwGetX11Display() {
        return JNI.invokeP(GLFWNativeX11$Functions.GetX11Display);
    }

    public static long glfwGetX11Adapter(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Adapter;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static long glfwGetX11Monitor(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Monitor;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static long glfwGetX11Window(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Window;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static void nglfwSetX11SelectionString(long l2) {
        long l3 = GLFWNativeX11$Functions.SetX11SelectionString;
        JNI.invokePV(l2, l3);
    }

    public static void glfwSetX11SelectionString(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        GLFWNativeX11.nglfwSetX11SelectionString(MemoryUtil.memAddress(byteBuffer));
    }

    public static void glfwSetX11SelectionString(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            GLFWNativeX11.nglfwSetX11SelectionString(memoryStack.getPointerAddress());
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nglfwGetX11SelectionString() {
        return JNI.invokeP(GLFWNativeX11$Functions.GetX11SelectionString);
    }

    public static String glfwGetX11SelectionString() {
        return MemoryUtil.memUTF8Safe(GLFWNativeX11.nglfwGetX11SelectionString());
    }
}

