/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFWAllocateCallback;
import org.lwjgl.glfw.GLFWAllocateCallbackI;
import org.lwjgl.glfw.GLFWAllocator$Buffer;
import org.lwjgl.glfw.GLFWDeallocateCallback;
import org.lwjgl.glfw.GLFWDeallocateCallbackI;
import org.lwjgl.glfw.GLFWReallocateCallback;
import org.lwjgl.glfw.GLFWReallocateCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class GLFWAllocator
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATE;
    public static final int REALLOCATE;
    public static final int DEALLOCATE;
    public static final int USER;

    protected GLFWAllocator(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected GLFWAllocator create(long l2, ByteBuffer byteBuffer) {
        return new GLFWAllocator(l2, byteBuffer);
    }

    public GLFWAllocator(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), GLFWAllocator.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public GLFWAllocateCallback allocate() {
        return GLFWAllocator.nallocate(this.address());
    }

    public GLFWReallocateCallback reallocate() {
        return GLFWAllocator.nreallocate(this.address());
    }

    public GLFWDeallocateCallback deallocate() {
        return GLFWAllocator.ndeallocate(this.address());
    }

    public long user() {
        return GLFWAllocator.nuser(this.address());
    }

    public GLFWAllocator allocate(GLFWAllocateCallbackI gLFWAllocateCallbackI) {
        GLFWAllocator.nallocate(this.address(), gLFWAllocateCallbackI);
        return this;
    }

    public GLFWAllocator reallocate(GLFWReallocateCallbackI gLFWReallocateCallbackI) {
        GLFWAllocator.nreallocate(this.address(), gLFWReallocateCallbackI);
        return this;
    }

    public GLFWAllocator deallocate(GLFWDeallocateCallbackI gLFWDeallocateCallbackI) {
        GLFWAllocator.ndeallocate(this.address(), gLFWDeallocateCallbackI);
        return this;
    }

    public GLFWAllocator user(long l2) {
        GLFWAllocator.nuser(this.address(), l2);
        return this;
    }

    public GLFWAllocator set(GLFWAllocateCallbackI gLFWAllocateCallbackI, GLFWReallocateCallbackI gLFWReallocateCallbackI, GLFWDeallocateCallbackI gLFWDeallocateCallbackI, long l2) {
        this.allocate(gLFWAllocateCallbackI);
        this.reallocate(gLFWReallocateCallbackI);
        this.deallocate(gLFWDeallocateCallbackI);
        this.user(l2);
        return this;
    }

    public GLFWAllocator set(GLFWAllocator gLFWAllocator) {
        MemoryUtil.memCopy(gLFWAllocator.address(), this.address(), SIZEOF);
        return this;
    }

    public static GLFWAllocator malloc() {
        return new GLFWAllocator(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static GLFWAllocator calloc() {
        return new GLFWAllocator(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static GLFWAllocator create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new GLFWAllocator(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static GLFWAllocator create(long l2) {
        return new GLFWAllocator(l2, null);
    }

    public static GLFWAllocator createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new GLFWAllocator(l2, null);
    }

    public static GLFWAllocator$Buffer malloc(int n2) {
        return new GLFWAllocator$Buffer(MemoryUtil.nmemAllocChecked(GLFWAllocator.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static GLFWAllocator$Buffer calloc(int n2) {
        return new GLFWAllocator$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static GLFWAllocator$Buffer create(int n2) {
        ByteBuffer byteBuffer = GLFWAllocator.__create(n2, SIZEOF);
        int n3 = n2;
        return new GLFWAllocator$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static GLFWAllocator$Buffer create(long l2, int n2) {
        return new GLFWAllocator$Buffer(l2, n2);
    }

    public static GLFWAllocator$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new GLFWAllocator$Buffer(l2, n2);
    }

    public static GLFWAllocator malloc(MemoryStack memoryStack) {
        return new GLFWAllocator(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static GLFWAllocator calloc(MemoryStack memoryStack) {
        return new GLFWAllocator(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static GLFWAllocator$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new GLFWAllocator$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static GLFWAllocator$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new GLFWAllocator$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static GLFWAllocateCallback nallocate(long l2) {
        return GLFWAllocateCallback.create(MemoryUtil.memGetAddress(l2 + (long)ALLOCATE));
    }

    public static GLFWReallocateCallback nreallocate(long l2) {
        return GLFWReallocateCallback.create(MemoryUtil.memGetAddress(l2 + (long)REALLOCATE));
    }

    public static GLFWDeallocateCallback ndeallocate(long l2) {
        return GLFWDeallocateCallback.create(MemoryUtil.memGetAddress(l2 + (long)DEALLOCATE));
    }

    public static long nuser(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)USER);
    }

    public static void nallocate(long l2, GLFWAllocateCallbackI gLFWAllocateCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)ALLOCATE, gLFWAllocateCallbackI.address());
    }

    public static void nreallocate(long l2, GLFWReallocateCallbackI gLFWReallocateCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)REALLOCATE, gLFWReallocateCallbackI.address());
    }

    public static void ndeallocate(long l2, GLFWDeallocateCallbackI gLFWDeallocateCallbackI) {
        MemoryUtil.memPutAddress(l2 + (long)DEALLOCATE, gLFWDeallocateCallbackI.address());
    }

    public static void nuser(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)USER, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)ALLOCATE));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)REALLOCATE));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DEALLOCATE));
    }

    static {
        Struct$Layout struct$Layout = GLFWAllocator.__struct(GLFWAllocator.__member(POINTER_SIZE), GLFWAllocator.__member(POINTER_SIZE), GLFWAllocator.__member(POINTER_SIZE), GLFWAllocator.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ALLOCATE = struct$Layout.offsetof(0);
        REALLOCATE = struct$Layout.offsetof(1);
        DEALLOCATE = struct$Layout.offsetof(2);
        USER = struct$Layout.offsetof(3);
    }
}

