/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_NV = 12518;
    public static final int EGL_SYNC_STATUS_NV = 12519;
    public static final int EGL_SIGNALED_NV = 12520;
    public static final int EGL_UNSIGNALED_NV = 12521;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_NV = 1;
    public static final int EGL_ALREADY_SIGNALED_NV = 12522;
    public static final int EGL_TIMEOUT_EXPIRED_NV = 12523;
    public static final int EGL_CONDITION_SATISFIED_NV = 12524;
    public static final int EGL_SYNC_TYPE_NV = 12525;
    public static final int EGL_SYNC_CONDITION_NV = 12526;
    public static final int EGL_SYNC_FENCE_NV = 12527;
    public static final long EGL_FOREVER_NV = -1L;
    public static final long EGL_NO_SYNC_NV = 0L;

    protected NVSync() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateFenceSyncNV(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglCreateFenceSyncNV;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPP(l2, n2, l3, l4);
    }

    public static long eglCreateFenceSyncNV(long l2, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT(intBuffer, 12344);
        }
        return NVSync.neglCreateFenceSyncNV(l2, n2, MemoryUtil.memAddress(intBuffer));
    }

    public static boolean eglDestroySyncNV(long l2) {
        long l3 = EGL.getCapabilities().eglDestroySyncNV;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3) != 0;
    }

    public static boolean eglFenceNV(long l2) {
        long l3 = EGL.getCapabilities().eglFenceNV;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3) != 0;
    }

    public static int eglClientWaitSyncNV(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglClientWaitSyncNV;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPJI(l2, n2, l3, l4);
    }

    public static boolean eglSignalSyncNV(long l2, int n2) {
        long l3 = EGL.getCapabilities().eglSignalSyncNV;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, n2, l3) != 0;
    }

    public static int neglGetSyncAttribNV(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglGetSyncAttribNV;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPI(l2, n2, l3, l4);
    }

    public static boolean eglGetSyncAttribNV(long l2, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return NVSync.neglGetSyncAttribNV(l2, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static long eglCreateFenceSyncNV(long l2, int n2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglCreateFenceSyncNV;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNT(nArray, 12344);
        }
        return JNI.callPPP(l2, n2, nArray, l3);
    }

    public static boolean eglGetSyncAttribNV(long l2, int n2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglGetSyncAttribNV;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        return JNI.callPPI(l2, n2, nArray, l3) != 0;
    }
}

