/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVStreamMetadata {
    public static final int EGL_MAX_STREAM_METADATA_BLOCKS_NV = 12880;
    public static final int EGL_MAX_STREAM_METADATA_BLOCK_SIZE_NV = 12881;
    public static final int EGL_MAX_STREAM_METADATA_TOTAL_SIZE_NV = 12882;
    public static final int EGL_PRODUCER_METADATA_NV = 12883;
    public static final int EGL_CONSUMER_METADATA_NV = 12884;
    public static final int EGL_PENDING_METADATA_NV = 13096;
    public static final int EGL_METADATA0_SIZE_NV = 12885;
    public static final int EGL_METADATA1_SIZE_NV = 12886;
    public static final int EGL_METADATA2_SIZE_NV = 12887;
    public static final int EGL_METADATA3_SIZE_NV = 12888;
    public static final int EGL_METADATA0_TYPE_NV = 12889;
    public static final int EGL_METADATA1_TYPE_NV = 12890;
    public static final int EGL_METADATA2_TYPE_NV = 12891;
    public static final int EGL_METADATA3_TYPE_NV = 12892;

    protected NVStreamMetadata() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDisplayAttribNV(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglQueryDisplayAttribNV;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPI(l2, n2, l3, l4);
    }

    public static boolean eglQueryDisplayAttribNV(long l2, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return NVStreamMetadata.neglQueryDisplayAttribNV(l2, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static int neglSetStreamMetadataNV(long l2, long l3, int n2, int n3, int n4, long l4) {
        long l5 = EGL.getCapabilities().eglSetStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, n3, n4, l4, l5);
    }

    public static boolean eglSetStreamMetadataNV(long l2, long l3, int n2, int n3, ByteBuffer byteBuffer) {
        return NVStreamMetadata.neglSetStreamMetadataNV(l2, l3, n2, n3, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer)) != 0;
    }

    public static int neglQueryStreamMetadataNV(long l2, long l3, int n2, int n3, int n4, int n5, long l4) {
        long l5 = EGL.getCapabilities().eglQueryStreamMetadataNV;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, n3, n4, n5, l4, l5);
    }

    public static boolean eglQueryStreamMetadataNV(long l2, long l3, int n2, int n3, int n4, ByteBuffer byteBuffer) {
        return NVStreamMetadata.neglQueryStreamMetadataNV(l2, l3, n2, n3, n4, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer)) != 0;
    }
}

