/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVStreamConsumerEGLImage {
    public static final int EGL_STREAM_CONSUMER_IMAGE_NV = 13171;
    public static final int EGL_STREAM_IMAGE_ADD_NV = 13172;
    public static final int EGL_STREAM_IMAGE_REMOVE_NV = 13173;
    public static final int EGL_STREAM_IMAGE_AVAILABLE_NV = 13174;

    protected NVStreamConsumerEGLImage() {
        throw new UnsupportedOperationException();
    }

    public static int neglStreamImageConsumerConnectNV(long l2, long l3, int n2, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPPI(l2, l3, n2, l4, l5, l6);
    }

    public static boolean eglStreamImageConsumerConnectNV(long l2, long l3, LongBuffer longBuffer, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(pointerBuffer, 12344L);
        }
        return NVStreamConsumerEGLImage.neglStreamImageConsumerConnectNV(l2, l3, longBuffer.remaining(), MemoryUtil.memAddress(longBuffer), MemoryUtil.memAddressSafe(pointerBuffer)) != 0;
    }

    public static int neglQueryStreamConsumerEventNV(long l2, long l3, long l4, long l5, long l6) {
        long l7 = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check(l7);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPJPPI(l2, l3, l4, l5, l6, l7);
    }

    public static int eglQueryStreamConsumerEventNV(long l2, long l3, long l4, IntBuffer intBuffer, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return NVStreamConsumerEGLImage.neglQueryStreamConsumerEventNV(l2, l3, l4, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(pointerBuffer));
    }

    public static int neglStreamAcquireImageNV(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglStreamAcquireImageNV;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l5);
        }
        return JNI.callPPPPI(l2, l3, l4, l5, l6);
    }

    public static boolean eglStreamAcquireImageNV(long l2, long l3, PointerBuffer pointerBuffer, long l4) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return NVStreamConsumerEGLImage.neglStreamAcquireImageNV(l2, l3, MemoryUtil.memAddress(pointerBuffer), l4) != 0;
    }

    public static boolean eglStreamReleaseImageNV(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglStreamReleaseImageNV;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
            Checks.check(l5);
        }
        return JNI.callPPPPI(l2, l3, l4, l5, l6) != 0;
    }

    public static boolean eglStreamImageConsumerConnectNV(long l2, long l3, long[] lArray, PointerBuffer pointerBuffer) {
        long l4 = EGL.getCapabilities().eglStreamImageConsumerConnectNV;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.checkNTSafe(pointerBuffer, 12344L);
        }
        return JNI.callPPPPI(l2, l3, lArray.length, lArray, MemoryUtil.memAddressSafe(pointerBuffer), l4) != 0;
    }

    public static int eglQueryStreamConsumerEventNV(long l2, long l3, long l4, int[] nArray, PointerBuffer pointerBuffer) {
        long l5 = EGL.getCapabilities().eglQueryStreamConsumerEventNV;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return JNI.callPPJPPI(l2, l3, l4, nArray, MemoryUtil.memAddress(pointerBuffer), l5);
    }
}

