/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class MESADRMImage {
    public static final int EGL_DRM_BUFFER_FORMAT_MESA = 12752;
    public static final int EGL_DRM_BUFFER_USE_MESA = 12753;
    public static final int EGL_DRM_BUFFER_FORMAT_ARGB32_MESA = 12754;
    public static final int EGL_DRM_BUFFER_MESA = 12755;
    public static final int EGL_DRM_BUFFER_STRIDE_MESA = 12756;
    public static final int EGL_DRM_BUFFER_USE_SCANOUT_MESA = 1;
    public static final int EGL_DRM_BUFFER_USE_SHARE_MESA = 2;

    protected MESADRMImage() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateDRMImageMESA(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPP(l2, l3, l4);
    }

    public static long eglCreateDRMImageMESA(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return MESADRMImage.neglCreateDRMImageMESA(l2, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static int neglExportDRMImageMESA(long l2, long l3, long l4, long l5, long l6) {
        long l7 = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check(l7);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPPPI(l2, l3, l4, l5, l6, l7);
    }

    public static boolean eglExportDRMImageMESA(long l2, long l3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.checkSafe((Buffer)intBuffer2, 1);
            Checks.checkSafe((Buffer)intBuffer3, 1);
        }
        return MESADRMImage.neglExportDRMImageMESA(l2, l3, MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer2), MemoryUtil.memAddressSafe(intBuffer3)) != 0;
    }

    public static long eglCreateDRMImageMESA(long l2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPP(l2, nArray, l3);
    }

    public static boolean eglExportDRMImageMESA(long l2, long l3, int[] nArray, int[] nArray2, int[] nArray3) {
        long l4 = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.checkSafe(nArray, 1);
            Checks.checkSafe(nArray2, 1);
            Checks.checkSafe(nArray3, 1);
        }
        return JNI.callPPPPPI(l2, l3, nArray, nArray2, nArray3, l4) != 0;
    }
}

