/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamFIFO {
    public static final int EGL_STREAM_FIFO_LENGTH_KHR = 12796;
    public static final int EGL_STREAM_TIME_NOW_KHR = 12797;
    public static final int EGL_STREAM_TIME_CONSUMER_KHR = 12798;
    public static final int EGL_STREAM_TIME_PRODUCER_KHR = 12799;

    protected KHRStreamFIFO() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryStreamTimeKHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryStreamTimeKHR(long l2, long l3, int n2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        return KHRStreamFIFO.neglQueryStreamTimeKHR(l2, l3, n2, MemoryUtil.memAddress(longBuffer)) != 0;
    }

    public static boolean eglQueryStreamTimeKHR(long l2, long l3, int n2, long[] lArray) {
        long l4 = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(lArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, lArray, l4) != 0;
    }
}

