/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStream {
    public static final long EGL_NO_STREAM_KHR = 0L;
    public static final int EGL_CONSUMER_LATENCY_USEC_KHR = 12816;
    public static final int EGL_PRODUCER_FRAME_KHR = 12818;
    public static final int EGL_CONSUMER_FRAME_KHR = 12819;
    public static final int EGL_STREAM_STATE_KHR = 12820;
    public static final int EGL_STREAM_STATE_CREATED_KHR = 12821;
    public static final int EGL_STREAM_STATE_CONNECTING_KHR = 12822;
    public static final int EGL_STREAM_STATE_EMPTY_KHR = 12823;
    public static final int EGL_STREAM_STATE_NEW_FRAME_AVAILABLE_KHR = 12824;
    public static final int EGL_STREAM_STATE_OLD_FRAME_AVAILABLE_KHR = 12825;
    public static final int EGL_STREAM_STATE_DISCONNECTED_KHR = 12826;
    public static final int EGL_BAD_STREAM_KHR = 12827;
    public static final int EGL_BAD_STATE_KHR = 12828;

    protected KHRStream() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateStreamKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglCreateStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPP(l2, l3, l4);
    }

    public static long eglCreateStreamKHR(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return KHRStream.neglCreateStreamKHR(l2, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static boolean eglDestroyStreamKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDestroyStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static boolean eglStreamAttribKHR(long l2, long l3, int n2, int n3) {
        long l4 = EGL.getCapabilities().eglStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, n2, n3, l4) != 0;
    }

    public static int neglQueryStreamKHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryStreamKHR(long l2, long l3, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return KHRStream.neglQueryStreamKHR(l2, l3, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static int neglQueryStreamu64KHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryStreamu64KHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryStreamu64KHR(long l2, long l3, int n2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, 1);
        }
        return KHRStream.neglQueryStreamu64KHR(l2, l3, n2, MemoryUtil.memAddress(longBuffer)) != 0;
    }

    public static long eglCreateStreamKHR(long l2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglCreateStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPP(l2, nArray, l3);
    }

    public static boolean eglQueryStreamKHR(long l2, long l3, int n2, int[] nArray) {
        long l4 = EGL.getCapabilities().eglQueryStreamKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, nArray, l4) != 0;
    }

    public static boolean eglQueryStreamu64KHR(long l2, long l3, int n2, long[] lArray) {
        long l4 = EGL.getCapabilities().eglQueryStreamu64KHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(lArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, lArray, l4) != 0;
    }
}

