/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRReusableSync {
    public static final int EGL_SYNC_STATUS_KHR = 12529;
    public static final int EGL_SIGNALED_KHR = 12530;
    public static final int EGL_UNSIGNALED_KHR = 12531;
    public static final int EGL_TIMEOUT_EXPIRED_KHR = 12533;
    public static final int EGL_CONDITION_SATISFIED_KHR = 12534;
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_REUSABLE_KHR = 12538;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 1;
    public static final long EGL_FOREVER_KHR = -1L;
    public static final long EGL_NO_SYNC_KHR = 0L;

    protected KHRReusableSync() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateSyncKHR(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPP(l2, n2, l3, l4);
    }

    public static long eglCreateSyncKHR(long l2, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return KHRReusableSync.neglCreateSyncKHR(l2, n2, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static boolean eglDestroySyncKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static int eglClientWaitSyncKHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPJI(l2, l3, n2, l4, l5);
    }

    public static boolean eglSignalSyncKHR(long l2, long l3, int n2) {
        long l4 = EGL.getCapabilities().eglSignalSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, n2, l4) != 0;
    }

    public static int neglGetSyncAttribKHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglGetSyncAttribKHR(long l2, long l3, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return KHRReusableSync.neglGetSyncAttribKHR(l2, l3, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static long eglCreateSyncKHR(long l2, int n2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPP(l2, n2, nArray, l3);
    }

    public static boolean eglGetSyncAttribKHR(long l2, long l3, int n2, int[] nArray) {
        long l4 = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, nArray, l4) != 0;
    }
}

