/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRLockSurface3 {
    public static final int EGL_READ_SURFACE_BIT_KHR = 1;
    public static final int EGL_WRITE_SURFACE_BIT_KHR = 2;
    public static final int EGL_LOCK_SURFACE_BIT_KHR = 128;
    public static final int EGL_OPTIMAL_FORMAT_BIT_KHR = 256;
    public static final int EGL_MATCH_FORMAT_KHR = 12355;
    public static final int EGL_FORMAT_RGB_565_EXACT_KHR = 12480;
    public static final int EGL_FORMAT_RGB_565_KHR = 12481;
    public static final int EGL_FORMAT_RGBA_8888_EXACT_KHR = 12482;
    public static final int EGL_FORMAT_RGBA_8888_KHR = 12483;
    public static final int EGL_MAP_PRESERVE_PIXELS_KHR = 12484;
    public static final int EGL_LOCK_USAGE_HINT_KHR = 12485;
    public static final int EGL_BITMAP_PITCH_KHR = 12487;
    public static final int EGL_BITMAP_ORIGIN_KHR = 12488;
    public static final int EGL_BITMAP_PIXEL_RED_OFFSET_KHR = 12489;
    public static final int EGL_BITMAP_PIXEL_GREEN_OFFSET_KHR = 12490;
    public static final int EGL_BITMAP_PIXEL_BLUE_OFFSET_KHR = 12491;
    public static final int EGL_BITMAP_PIXEL_ALPHA_OFFSET_KHR = 12492;
    public static final int EGL_BITMAP_PIXEL_LUMINANCE_OFFSET_KHR = 12493;
    public static final int EGL_BITMAP_PIXEL_SIZE_KHR = 12560;
    public static final int EGL_BITMAP_POINTER_KHR = 12486;
    public static final int EGL_LOWER_LEFT_KHR = 12494;
    public static final int EGL_UPPER_LEFT_KHR = 12495;

    protected KHRLockSurface3() {
        throw new UnsupportedOperationException();
    }

    public static int neglLockSurfaceKHR(long l2, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglLockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, l4, l5);
    }

    public static boolean eglLockSurfaceKHR(long l2, long l3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return KHRLockSurface3.neglLockSurfaceKHR(l2, l3, MemoryUtil.memAddressSafe(intBuffer)) != 0;
    }

    public static boolean eglUnlockSurfaceKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglUnlockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static int neglQuerySurface64KHR(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQuerySurface64KHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQuerySurface64KHR(long l2, long l3, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return KHRLockSurface3.neglQuerySurface64KHR(l2, l3, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static boolean eglLockSurfaceKHR(long l2, long l3, int[] nArray) {
        long l4 = EGL.getCapabilities().eglLockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPI(l2, l3, nArray, l4) != 0;
    }
}

