/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRImageBase {
    public static final int EGL_IMAGE_PRESERVED_KHR = 12498;
    public static final long EGL_NO_IMAGE_KHR = 0L;

    protected KHRImageBase() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateImageKHR(long l2, long l3, int n2, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.callPPPPP(l2, l3, n2, l4, l5, l6);
    }

    public static long eglCreateImageKHR(long l2, long l3, int n2, long l4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return KHRImageBase.neglCreateImageKHR(l2, l3, n2, l4, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static boolean eglDestroyImageKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static long eglCreateImageKHR(long l2, long l3, int n2, long l4, int[] nArray) {
        long l5 = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPPP(l2, l3, n2, l4, nArray, l5);
    }
}

