/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLDebugMessageKHRCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRDebug {
    public static final int EGL_OBJECT_THREAD_KHR = 13232;
    public static final int EGL_OBJECT_DISPLAY_KHR = 13233;
    public static final int EGL_OBJECT_CONTEXT_KHR = 13234;
    public static final int EGL_OBJECT_SURFACE_KHR = 13235;
    public static final int EGL_OBJECT_IMAGE_KHR = 13236;
    public static final int EGL_OBJECT_SYNC_KHR = 13237;
    public static final int EGL_OBJECT_STREAM_KHR = 13238;
    public static final int EGL_DEBUG_MSG_CRITICAL_KHR = 13241;
    public static final int EGL_DEBUG_MSG_ERROR_KHR = 13242;
    public static final int EGL_DEBUG_MSG_WARN_KHR = 13243;
    public static final int EGL_DEBUG_MSG_INFO_KHR = 13244;
    public static final int EGL_DEBUG_CALLBACK_KHR = 13240;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    public static int neglDebugMessageControlKHR(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDebugMessageControlKHR;
        if (Checks.CHECKS) {
            Checks.check(l4);
        }
        return JNI.callPPI(l2, l3, l4);
    }

    public static int eglDebugMessageControlKHR(EGLDebugMessageKHRCallbackI eGLDebugMessageKHRCallbackI, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(pointerBuffer, 12344L);
        }
        return KHRDebug.neglDebugMessageControlKHR(eGLDebugMessageKHRCallbackI.address(), MemoryUtil.memAddressSafe(pointerBuffer));
    }

    public static int neglQueryDebugKHR(int n2, long l2) {
        long l3 = EGL.getCapabilities().eglQueryDebugKHR;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.callPI(n2, l2, l3);
    }

    public static boolean eglQueryDebugKHR(int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return KHRDebug.neglQueryDebugKHR(n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static int eglLabelObjectKHR(long l2, int n2, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglLabelObjectKHR;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.callPPPI(l2, n2, l3, l4, l5);
    }
}

