/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTOutputBase {
    public static final int EGL_BAD_OUTPUT_LAYER_EXT = 12845;
    public static final int EGL_BAD_OUTPUT_PORT_EXT = 12846;
    public static final int EGL_SWAP_INTERVAL_EXT = 12847;
    public static final long EGL_NO_OUTPUT_LAYER_EXT = 0L;
    public static final long EGL_NO_OUTPUT_PORT_EXT = 0L;

    protected EXTOutputBase() {
        throw new UnsupportedOperationException();
    }

    public static int neglGetOutputLayersEXT(long l2, long l3, long l4, int n2, long l5) {
        long l6 = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
        }
        return JNI.callPPPPI(l2, l3, l4, n2, l5, l6);
    }

    public static boolean eglGetOutputLayersEXT(long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(pointerBuffer, 12344L);
            Checks.check((Buffer)intBuffer, 1);
        }
        return EXTOutputBase.neglGetOutputLayersEXT(l2, MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer2), Checks.remainingSafe(pointerBuffer2), MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static int neglGetOutputPortsEXT(long l2, long l3, long l4, int n2, long l5) {
        long l6 = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
        }
        return JNI.callPPPPI(l2, l3, l4, n2, l5, l6);
    }

    public static boolean eglGetOutputPortsEXT(long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(pointerBuffer, 12344L);
            Checks.check((Buffer)intBuffer, 1);
        }
        return EXTOutputBase.neglGetOutputPortsEXT(l2, MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer2), Checks.remainingSafe(pointerBuffer2), MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static boolean eglOutputLayerAttribEXT(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5) != 0;
    }

    public static int neglQueryOutputLayerAttribEXT(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryOutputLayerAttribEXT(long l2, long l3, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return EXTOutputBase.neglQueryOutputLayerAttribEXT(l2, l3, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static long neglQueryOutputLayerStringEXT(long l2, long l3, int n2) {
        long l4 = EGL.getCapabilities().eglQueryOutputLayerStringEXT;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPP(l2, l3, n2, l4);
    }

    public static String eglQueryOutputLayerStringEXT(long l2, long l3, int n2) {
        return MemoryUtil.memASCIISafe(EXTOutputBase.neglQueryOutputLayerStringEXT(l2, l3, n2));
    }

    public static boolean eglOutputPortAttribEXT(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5) != 0;
    }

    public static int neglQueryOutputPortAttribEXT(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryOutputPortAttribEXT(long l2, long l3, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return EXTOutputBase.neglQueryOutputPortAttribEXT(l2, l3, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static long neglQueryOutputPortStringEXT(long l2, long l3, int n2) {
        long l4 = EGL.getCapabilities().eglQueryOutputPortStringEXT;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPP(l2, l3, n2, l4);
    }

    public static String eglQueryOutputPortStringEXT(long l2, long l3, int n2) {
        return MemoryUtil.memASCIISafe(EXTOutputBase.neglQueryOutputPortStringEXT(l2, l3, n2));
    }

    public static boolean eglGetOutputLayersEXT(long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglGetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(pointerBuffer, 12344L);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPPI(l2, MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer2), Checks.remainingSafe(pointerBuffer2), nArray, l3) != 0;
    }

    public static boolean eglGetOutputPortsEXT(long l2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, int[] nArray) {
        long l3 = EGL.getCapabilities().eglGetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(pointerBuffer, 12344L);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPPI(l2, MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer2), Checks.remainingSafe(pointerBuffer2), nArray, l3) != 0;
    }
}

