/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDeviceQuery {
    public static final int EGL_BAD_DEVICE_EXT = 12843;
    public static final int EGL_DEVICE_EXT = 12844;
    public static final long EGL_NO_DEVICE_EXT = 0L;

    protected EXTDeviceQuery() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDeviceAttribEXT(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglQueryDeviceAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPI(l2, n2, l3, l4);
    }

    public static boolean eglQueryDeviceAttribEXT(long l2, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return EXTDeviceQuery.neglQueryDeviceAttribEXT(l2, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }

    public static long neglQueryDeviceStringEXT(long l2, int n2) {
        long l3 = EGL.getCapabilities().eglQueryDeviceStringEXT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPP(l2, n2, l3);
    }

    public static String eglQueryDeviceStringEXT(long l2, int n2) {
        return MemoryUtil.memASCIISafe(EXTDeviceQuery.neglQueryDeviceStringEXT(l2, n2));
    }

    public static int neglQueryDisplayAttribEXT(long l2, int n2, long l3) {
        long l4 = EGL.getCapabilities().eglQueryDisplayAttribEXT;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        return JNI.callPPI(l2, n2, l3, l4);
    }

    public static boolean eglQueryDisplayAttribEXT(long l2, int n2, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return EXTDeviceQuery.neglQueryDisplayAttribEXT(l2, n2, MemoryUtil.memAddress(pointerBuffer)) != 0;
    }
}

