/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDevicePersistentID {
    public static final int EGL_DRIVER_NAME_EXT = 13150;
    public static final int EGL_DEVICE_UUID_EXT = 13148;
    public static final int EGL_DRIVER_UUID_EXT = 13149;

    protected EXTDevicePersistentID() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDeviceBinaryEXT(long l2, int n2, int n3, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglQueryDeviceBinaryEXT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
        }
        return JNI.callPPPI(l2, n2, n3, l3, l4, l5);
    }

    public static boolean eglQueryDeviceBinaryEXT(long l2, int n2, ByteBuffer byteBuffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return EXTDevicePersistentID.neglQueryDeviceBinaryEXT(l2, n2, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static boolean eglQueryDeviceBinaryEXT(long l2, int n2, ByteBuffer byteBuffer, int[] nArray) {
        long l3 = EGL.getCapabilities().eglQueryDeviceBinaryEXT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, n2, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer), nArray, l3) != 0;
    }
}

