/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.egl.EGLClientPixmapHI$Buffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

public class EGLClientPixmapHI
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    protected EGLClientPixmapHI(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected EGLClientPixmapHI create(long l2, ByteBuffer byteBuffer) {
        return new EGLClientPixmapHI(l2, byteBuffer);
    }

    public EGLClientPixmapHI(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), EGLClientPixmapHI.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer pData(int n2) {
        return EGLClientPixmapHI.npData(this.address(), n2);
    }

    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(ByteBuffer byteBuffer) {
        EGLClientPixmapHI.npData(this.address(), byteBuffer);
        return this;
    }

    public EGLClientPixmapHI iWidth(int n2) {
        EGLClientPixmapHI.niWidth(this.address(), n2);
        return this;
    }

    public EGLClientPixmapHI iHeight(int n2) {
        EGLClientPixmapHI.niHeight(this.address(), n2);
        return this;
    }

    public EGLClientPixmapHI iStride(int n2) {
        EGLClientPixmapHI.niStride(this.address(), n2);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        this.pData(byteBuffer);
        this.iWidth(n2);
        this.iHeight(n3);
        this.iStride(n4);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI eGLClientPixmapHI) {
        MemoryUtil.memCopy(eGLClientPixmapHI.address(), this.address(), SIZEOF);
        return this;
    }

    public static EGLClientPixmapHI malloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EGLClientPixmapHI calloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EGLClientPixmapHI create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new EGLClientPixmapHI(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static EGLClientPixmapHI create(long l2) {
        return new EGLClientPixmapHI(l2, null);
    }

    public static EGLClientPixmapHI createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new EGLClientPixmapHI(l2, null);
    }

    public static EGLClientPixmapHI$Buffer malloc(int n2) {
        return new EGLClientPixmapHI$Buffer(MemoryUtil.nmemAllocChecked(EGLClientPixmapHI.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static EGLClientPixmapHI$Buffer calloc(int n2) {
        return new EGLClientPixmapHI$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static EGLClientPixmapHI$Buffer create(int n2) {
        ByteBuffer byteBuffer = EGLClientPixmapHI.__create(n2, SIZEOF);
        int n3 = n2;
        return new EGLClientPixmapHI$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static EGLClientPixmapHI$Buffer create(long l2, int n2) {
        return new EGLClientPixmapHI$Buffer(l2, n2);
    }

    public static EGLClientPixmapHI$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new EGLClientPixmapHI$Buffer(l2, n2);
    }

    public static EGLClientPixmapHI mallocStack() {
        return EGLClientPixmapHI.malloc(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI callocStack() {
        return EGLClientPixmapHI.calloc(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI mallocStack(MemoryStack memoryStack) {
        return EGLClientPixmapHI.malloc(memoryStack);
    }

    public static EGLClientPixmapHI callocStack(MemoryStack memoryStack) {
        return EGLClientPixmapHI.calloc(memoryStack);
    }

    public static EGLClientPixmapHI$Buffer mallocStack(int n2) {
        return EGLClientPixmapHI.malloc(n2, MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI$Buffer callocStack(int n2) {
        return EGLClientPixmapHI.calloc(n2, MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return EGLClientPixmapHI.malloc(n2, memoryStack);
    }

    public static EGLClientPixmapHI$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return EGLClientPixmapHI.calloc(n2, memoryStack);
    }

    public static EGLClientPixmapHI malloc(MemoryStack memoryStack) {
        return new EGLClientPixmapHI(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EGLClientPixmapHI calloc(MemoryStack memoryStack) {
        return new EGLClientPixmapHI(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static EGLClientPixmapHI$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new EGLClientPixmapHI$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static EGLClientPixmapHI$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new EGLClientPixmapHI$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer npData(long l2, int n2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)PDATA), n2);
    }

    public static int niWidth(long l2) {
        return UNSAFE.getInt(null, l2 + (long)IWIDTH);
    }

    public static int niHeight(long l2) {
        return UNSAFE.getInt(null, l2 + (long)IHEIGHT);
    }

    public static int niStride(long l2) {
        return UNSAFE.getInt(null, l2 + (long)ISTRIDE);
    }

    public static void npData(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)PDATA, MemoryUtil.memAddress(byteBuffer));
    }

    public static void niWidth(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)IWIDTH, n2);
    }

    public static void niHeight(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)IHEIGHT, n2);
    }

    public static void niStride(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)ISTRIDE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)PDATA));
    }

    static {
        Struct$Layout struct$Layout = EGLClientPixmapHI.__struct(EGLClientPixmapHI.__member(POINTER_SIZE), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        PDATA = struct$Layout.offsetof(0);
        IWIDTH = struct$Layout.offsetof(1);
        IHEIGHT = struct$Layout.offsetof(2);
        ISTRIDE = struct$Layout.offsetof(3);
    }
}

