/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EGL10 {
    public static final int EGL_ALPHA_SIZE = 12321;
    public static final int EGL_BAD_ACCESS = 12290;
    public static final int EGL_BAD_ALLOC = 12291;
    public static final int EGL_BAD_ATTRIBUTE = 12292;
    public static final int EGL_BAD_CONFIG = 12293;
    public static final int EGL_BAD_CONTEXT = 12294;
    public static final int EGL_BAD_CURRENT_SURFACE = 12295;
    public static final int EGL_BAD_DISPLAY = 12296;
    public static final int EGL_BAD_MATCH = 12297;
    public static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    public static final int EGL_BAD_NATIVE_WINDOW = 12299;
    public static final int EGL_BAD_PARAMETER = 12300;
    public static final int EGL_BAD_SURFACE = 12301;
    public static final int EGL_BLUE_SIZE = 12322;
    public static final int EGL_BUFFER_SIZE = 12320;
    public static final int EGL_CONFIG_CAVEAT = 12327;
    public static final int EGL_CONFIG_ID = 12328;
    public static final int EGL_CORE_NATIVE_ENGINE = 12379;
    public static final int EGL_DEPTH_SIZE = 12325;
    public static final int EGL_DONT_CARE = -1;
    public static final int EGL_DRAW = 12377;
    public static final int EGL_EXTENSIONS = 12373;
    public static final int EGL_FALSE = 0;
    public static final int EGL_GREEN_SIZE = 12323;
    public static final int EGL_HEIGHT = 12374;
    public static final int EGL_LARGEST_PBUFFER = 12376;
    public static final int EGL_LEVEL = 12329;
    public static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    public static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    public static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    public static final int EGL_NATIVE_RENDERABLE = 12333;
    public static final int EGL_NATIVE_VISUAL_ID = 12334;
    public static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    public static final int EGL_NONE = 12344;
    public static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    public static final int EGL_NOT_INITIALIZED = 12289;
    public static final int EGL_PBUFFER_BIT = 1;
    public static final int EGL_PIXMAP_BIT = 2;
    public static final int EGL_READ = 12378;
    public static final int EGL_RED_SIZE = 12324;
    public static final int EGL_SAMPLES = 12337;
    public static final int EGL_SAMPLE_BUFFERS = 12338;
    public static final int EGL_SLOW_CONFIG = 12368;
    public static final int EGL_STENCIL_SIZE = 12326;
    public static final int EGL_SUCCESS = 12288;
    public static final int EGL_SURFACE_TYPE = 12339;
    public static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    public static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    public static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    public static final int EGL_TRANSPARENT_RGB = 12370;
    public static final int EGL_TRANSPARENT_TYPE = 12340;
    public static final int EGL_TRUE = 1;
    public static final int EGL_VENDOR = 12371;
    public static final int EGL_VERSION = 12372;
    public static final int EGL_WIDTH = 12375;
    public static final int EGL_WINDOW_BIT = 4;
    public static final long EGL_NO_CONTEXT = 0L;
    public static final long EGL_NO_DISPLAY = 0L;
    public static final long EGL_NO_SURFACE = 0L;

    protected EGL10() {
        throw new UnsupportedOperationException();
    }

    public static int neglChooseConfig(long l2, long l3, long l4, int n2, long l5) {
        long l6 = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
        }
        return JNI.callPPPPI(l2, l3, l4, n2, l5, l6);
    }

    public static boolean eglChooseConfig(long l2, IntBuffer intBuffer, PointerBuffer pointerBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
            Checks.check((Buffer)intBuffer2, 1);
        }
        return EGL10.neglChooseConfig(l2, MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddress(intBuffer2)) != 0;
    }

    public static boolean eglCopyBuffers(long l2, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglCopyBuffers;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.callPPPI(l2, l3, l4, l5) != 0;
    }

    public static long neglCreateContext(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPPP(l2, l3, l4, l5, l6);
    }

    public static long eglCreateContext(long l2, long l3, long l4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return EGL10.neglCreateContext(l2, l3, l4, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static long neglCreatePbufferSurface(long l2, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPP(l2, l3, l4, l5);
    }

    public static long eglCreatePbufferSurface(long l2, long l3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return EGL10.neglCreatePbufferSurface(l2, l3, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static long neglCreatePixmapSurface(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.callPPPPP(l2, l3, l4, l5, l6);
    }

    public static long eglCreatePixmapSurface(long l2, long l3, long l4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return EGL10.neglCreatePixmapSurface(l2, l3, l4, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static long neglCreateWindowSurface(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.callPPPPP(l2, l3, l4, l5, l6);
    }

    public static long eglCreateWindowSurface(long l2, long l3, long l4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer, 12344);
        }
        return EGL10.neglCreateWindowSurface(l2, l3, l4, MemoryUtil.memAddressSafe(intBuffer));
    }

    public static boolean eglDestroyContext(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDestroyContext;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static boolean eglDestroySurface(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglDestroySurface;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static int neglGetConfigAttrib(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglGetConfigAttrib(long l2, long l3, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return EGL10.neglGetConfigAttrib(l2, l3, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static int neglGetConfigs(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglGetConfigs(long l2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return EGL10.neglGetConfigs(l2, MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static long eglGetCurrentDisplay() {
        long l2 = EGL.getCapabilities().eglGetCurrentDisplay;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callP(l2);
    }

    public static long eglGetCurrentSurface(int n2) {
        long l2 = EGL.getCapabilities().eglGetCurrentSurface;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callP(n2, l2);
    }

    public static long eglGetDisplay(long l2) {
        long l3 = EGL.getCapabilities().eglGetDisplay;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.callPP(l2, l3);
    }

    public static int eglGetError() {
        long l2 = EGL.getCapabilities().eglGetError;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callI(l2);
    }

    public static long neglGetProcAddress(long l2) {
        long l3 = EGL.getCapabilities().eglGetProcAddress;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.callPP(l2, l3);
    }

    public static long eglGetProcAddress(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return EGL10.neglGetProcAddress(MemoryUtil.memAddress(byteBuffer));
    }

    public static long eglGetProcAddress(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = EGL10.neglGetProcAddress(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int neglInitialize(long l2, long l3, long l4) {
        long l5 = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
        }
        return JNI.callPPPI(l2, l3, l4, l5);
    }

    public static boolean eglInitialize(long l2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.checkSafe((Buffer)intBuffer2, 1);
        }
        return EGL10.neglInitialize(l2, MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer2)) != 0;
    }

    public static boolean eglMakeCurrent(long l2, long l3, long l4, long l5) {
        long l6 = EGL.getCapabilities().eglMakeCurrent;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
        }
        return JNI.callPPPPI(l2, l3, l4, l5, l6) != 0;
    }

    public static int neglQueryContext(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQueryContext(long l2, long l3, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return EGL10.neglQueryContext(l2, l3, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static long neglQueryString(long l2, int n2) {
        long l3 = EGL.getCapabilities().eglQueryString;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.callPP(l2, n2, l3);
    }

    public static String eglQueryString(long l2, int n2) {
        return MemoryUtil.memASCIISafe(EGL10.neglQueryString(l2, n2));
    }

    public static int neglQuerySurface(long l2, long l3, int n2, long l4) {
        long l5 = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPPI(l2, l3, n2, l4, l5);
    }

    public static boolean eglQuerySurface(long l2, long l3, int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        return EGL10.neglQuerySurface(l2, l3, n2, MemoryUtil.memAddress(intBuffer)) != 0;
    }

    public static boolean eglSwapBuffers(long l2, long l3) {
        long l4 = EGL.getCapabilities().eglSwapBuffers;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.callPPI(l2, l3, l4) != 0;
    }

    public static boolean eglTerminate(long l2) {
        long l3 = EGL.getCapabilities().eglTerminate;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
        }
        return JNI.callPI(l2, l3) != 0;
    }

    public static boolean eglWaitGL() {
        long l2 = EGL.getCapabilities().eglWaitGL;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callI(l2) != 0;
    }

    public static boolean eglWaitNative(int n2) {
        long l2 = EGL.getCapabilities().eglWaitNative;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.callI(n2, l2) != 0;
    }

    public static boolean eglChooseConfig(long l2, int[] nArray, PointerBuffer pointerBuffer, int[] nArray2) {
        long l3 = EGL.getCapabilities().eglChooseConfig;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray, 12344);
            Checks.check(nArray2, 1);
        }
        return JNI.callPPPPI(l2, nArray, MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer), nArray2, l3) != 0;
    }

    public static long eglCreateContext(long l2, long l3, long l4, int[] nArray) {
        long l5 = EGL.getCapabilities().eglCreateContext;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPPP(l2, l3, l4, nArray, l5);
    }

    public static long eglCreatePbufferSurface(long l2, long l3, int[] nArray) {
        long l4 = EGL.getCapabilities().eglCreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPP(l2, l3, nArray, l4);
    }

    public static long eglCreatePixmapSurface(long l2, long l3, long l4, int[] nArray) {
        long l5 = EGL.getCapabilities().eglCreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPPP(l2, l3, l4, nArray, l5);
    }

    public static long eglCreateWindowSurface(long l2, long l3, long l4, int[] nArray) {
        long l5 = EGL.getCapabilities().eglCreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
            Checks.checkNTSafe(nArray, 12344);
        }
        return JNI.callPPPPP(l2, l3, l4, nArray, l5);
    }

    public static boolean eglGetConfigAttrib(long l2, long l3, int n2, int[] nArray) {
        long l4 = EGL.getCapabilities().eglGetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, nArray, l4) != 0;
    }

    public static boolean eglGetConfigs(long l2, PointerBuffer pointerBuffer, int[] nArray) {
        long l3 = EGL.getCapabilities().eglGetConfigs;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer), nArray, l3) != 0;
    }

    public static boolean eglInitialize(long l2, int[] nArray, int[] nArray2) {
        long l3 = EGL.getCapabilities().eglInitialize;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
            Checks.checkSafe(nArray2, 1);
        }
        return JNI.callPPPI(l2, nArray, nArray2, l3) != 0;
    }

    public static boolean eglQueryContext(long l2, long l3, int n2, int[] nArray) {
        long l4 = EGL.getCapabilities().eglQueryContext;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, nArray, l4) != 0;
    }

    public static boolean eglQuerySurface(long l2, long l3, int n2, int[] nArray) {
        long l4 = EGL.getCapabilities().eglQuerySurface;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(nArray, 1);
        }
        return JNI.callPPPI(l2, l3, n2, nArray, l4) != 0;
    }
}

