/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.egl.EGL$1;
import org.lwjgl.egl.EGL10;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class EGL {
    private static FunctionProvider functionProvider;
    private static EGLCapabilities caps;

    private EGL() {
    }

    public static void create() {
        SharedLibrary sharedLibrary;
        switch (Platform.get()) {
            case LINUX: {
                sharedLibrary = Library.loadNative(EGL.class, "org.lwjgl.egl", Configuration.EGL_LIBRARY_NAME, "libEGL.so.1");
                break;
            }
            case MACOSX: {
                sharedLibrary = Library.loadNative(EGL.class, "org.lwjgl.egl", Configuration.EGL_LIBRARY_NAME, "EGL");
                break;
            }
            case WINDOWS: {
                sharedLibrary = Library.loadNative(EGL.class, "org.lwjgl.egl", Configuration.EGL_LIBRARY_NAME, "libEGL", "EGL");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        EGL.create(sharedLibrary);
    }

    public static void create(String string) {
        EGL.create(Library.loadNative(EGL.class, "org.lwjgl.egl", string));
    }

    private static void create(SharedLibrary sharedLibrary) {
        try {
            EGL.create((FunctionProvider)new EGL$1(sharedLibrary));
            return;
        }
        catch (RuntimeException runtimeException) {
            sharedLibrary.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (EGL.functionProvider != null) {
            throw new IllegalStateException("EGL has already been created.");
        }
        EGL.functionProvider = functionProvider;
        caps = EGL.createClientCapabilities();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        caps = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    static Object check(Object object) {
        if (object == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        return object;
    }

    public static FunctionProvider getFunctionProvider() {
        return (FunctionProvider)EGL.check(functionProvider);
    }

    public static EGLCapabilities getCapabilities() {
        return (EGLCapabilities)EGL.check(caps);
    }

    private static EGLCapabilities createClientCapabilities() {
        FunctionProvider functionProvider = EGL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        HashSet hashSet = new HashSet(32);
        long l2 = functionProvider.getFunctionAddress("eglQueryString");
        if (JNI.callPP(0L, 12373, l2) == 0L) {
            JNI.callI(functionProvider.getFunctionAddress("eglGetError"));
        } else {
            Object object = MemoryUtil.memASCIISafe(JNI.callPP(0L, 12372, l2));
            if (object == null) {
                JNI.callI(functionProvider.getFunctionAddress("eglGetError"));
            } else {
                object = APIUtil.apiParseVersion((String)object);
                EGL.addEGLVersions(((APIUtil$APIVersion)object).major, ((APIUtil$APIVersion)object).minor, hashSet);
            }
        }
        APIUtil.apiFilterExtensions(hashSet, Configuration.EGL_EXTENSION_FILTER);
        return new EGLCapabilities(functionProvider, hashSet);
    }

    public static EGLCapabilities createDisplayCapabilities(long l2) {
        Object object = EGL10.eglQueryString(l2, 12372);
        if (object == null) {
            throw new IllegalArgumentException("Invalid EGLDisplay handle specified.");
        }
        object = APIUtil.apiParseVersion((String)object);
        return EGL.createDisplayCapabilities(l2, ((APIUtil$APIVersion)object).major, ((APIUtil$APIVersion)object).minor);
    }

    public static EGLCapabilities createDisplayCapabilities(long l2, int n2, int n3) {
        if (functionProvider == null) {
            throw new IllegalStateException("EGL library has not been loaded.");
        }
        HashSet hashSet = new HashSet(32);
        EGL.addEGLVersions(n2, n3, hashSet);
        String string = EGL10.eglQueryString(l2, 12373);
        if (string != null) {
            EGL.addExtensions(string, hashSet);
        }
        return new EGLCapabilities(Objects.requireNonNull(caps), hashSet);
    }

    private static void addEGLVersions(int n2, int n3, Set set) {
        int[][] nArrayArray = new int[][]{{0, 1, 2, 3, 4, 5}};
        block0: for (int i2 = 1; i2 <= Math.min(n2, nArrayArray.length); ++i2) {
            for (int n4 : nArrayArray[i2 - 1]) {
                if (i2 == n2 && n3 < n4) continue block0;
                set.add("EGL" + i2 + n4);
            }
        }
    }

    private static void addExtensions(String object, Set set) {
        object = new StringTokenizer((String)object);
        while (((StringTokenizer)object).hasMoreTokens()) {
            set.add(((StringTokenizer)object).nextToken());
        }
    }

    static {
        if (!((Boolean)Configuration.EGL_EXPLICIT_INIT.get(Boolean.FALSE)).booleanValue()) {
            EGL.create();
        }
    }
}

