/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

public class Elements
extends ArrayList {
    public Elements() {
    }

    public Elements(int n2) {
        super(n2);
    }

    public Elements(Collection collection) {
        super(collection);
    }

    public Elements(List list) {
        super(list);
    }

    public Elements(Element ... elementArray) {
        super(Arrays.asList(elementArray));
    }

    public Elements clone() {
        Elements elements = new Elements(this.size());
        for (Element element : this) {
            elements.add(element.clone());
        }
        return elements;
    }

    public String attr(String string) {
        for (Element element : this) {
            if (!element.hasAttr(string)) continue;
            return element.attr(string);
        }
        return "";
    }

    public boolean hasAttr(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!((Element)iterator.next()).hasAttr(string)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String string, String string2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).attr(string, string2);
        }
        return this;
    }

    public Elements removeAttr(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).removeAttr(string);
        }
        return this;
    }

    public Elements addClass(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).addClass(string);
        }
        return this;
    }

    public Elements removeClass(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).removeClass(string);
        }
        return this;
    }

    public Elements toggleClass(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).toggleClass(string);
        }
        return this;
    }

    public boolean hasClass(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!((Element)iterator.next()).hasClass(string)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).val(string);
        }
        return this;
    }

    public String text() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(element.text());
        }
        return stringBuilder.toString();
    }

    public boolean hasText() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!((Element)iterator.next()).hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.html());
        }
        return stringBuilder.toString();
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.outerHtml());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).tagName(string);
        }
        return this;
    }

    public Elements html(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).html(string);
        }
        return this;
    }

    public Elements prepend(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).prepend(string);
        }
        return this;
    }

    public Elements append(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).append(string);
        }
        return this;
    }

    public Elements before(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).before(string);
        }
        return this;
    }

    public Elements after(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).after(string);
        }
        return this;
    }

    public Elements wrap(String string) {
        Validate.notEmpty(string);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).wrap(string);
        }
        return this;
    }

    public Elements unwrap() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).unwrap();
        }
        return this;
    }

    public Elements empty() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).empty();
        }
        return this;
    }

    public Elements remove() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).remove();
        }
        return this;
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Elements not(String object) {
        object = Selector.select((String)object, this);
        return Selector.a(this, (Elements)object);
    }

    public Elements eq(int n2) {
        if (this.size() > n2) {
            return new Elements((Element)this.get(n2));
        }
        return new Elements();
    }

    public boolean is(String string) {
        return !this.select(string).isEmpty();
    }

    public Elements parents() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Element element : this) {
            linkedHashSet.addAll(element.parents());
        }
        return new Elements((Collection)linkedHashSet);
    }

    public Element first() {
        if (this.isEmpty()) {
            return null;
        }
        return (Element)this.get(0);
    }

    public Element last() {
        if (this.isEmpty()) {
            return null;
        }
        Elements elements = this;
        return (Element)elements.get(elements.size() - 1);
    }

    public Elements traverse(NodeVisitor object) {
        Validate.notNull(object);
        object = new NodeTraversor((NodeVisitor)object);
        for (Element element : this) {
            ((NodeTraversor)object).traverse(element);
        }
        return this;
    }

    public List forms() {
        ArrayList<FormElement> arrayList = new ArrayList<FormElement>();
        for (Element element : this) {
            if (!(element instanceof FormElement)) continue;
            arrayList.add((FormElement)element);
        }
        return arrayList;
    }
}

