/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;

public class TokenQueue {
    private String a;
    private int b = 0;

    public TokenQueue(String string) {
        Validate.notNull(string);
        this.a = string;
    }

    public boolean isEmpty() {
        return this.a() == 0;
    }

    private int a() {
        return this.a.length() - this.b;
    }

    public char peek() {
        if (this.isEmpty()) {
            return '\u0000';
        }
        return this.a.charAt(this.b);
    }

    public void addFirst(Character c2) {
        this.addFirst(c2.toString());
    }

    public void addFirst(String string) {
        this.a = string + this.a.substring(this.b);
        this.b = 0;
    }

    public boolean matches(String string) {
        return this.a.regionMatches(true, this.b, string, 0, string.length());
    }

    public boolean matchesCS(String string) {
        return this.a.startsWith(string, this.b);
    }

    public boolean matchesAny(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.matches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c2 : cArray) {
            if (this.a.charAt(this.b) != c2) continue;
            return true;
        }
        return false;
    }

    public boolean matchesStartTag() {
        return this.a() >= 2 && this.a.charAt(this.b) == '<' && Character.isLetter(this.a.charAt(this.b + 1));
    }

    public boolean matchChomp(String string) {
        if (this.matches(string)) {
            this.b += string.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.a.charAt(this.b));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.a.charAt(this.b));
    }

    public void advance() {
        if (!this.isEmpty()) {
            ++this.b;
        }
    }

    public char consume() {
        return this.a.charAt(this.b++);
    }

    public void consume(String string) {
        if (!this.matches(string)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int n2 = string.length();
        if (n2 > this.a()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        this.b += n2;
    }

    public String consumeTo(String string) {
        int n2 = this.a.indexOf(string, this.b);
        if (n2 != -1) {
            String string2 = this.a.substring(this.b, n2);
            this.b += string2.length();
            return string2;
        }
        return this.remainder();
    }

    public String consumeToIgnoreCase(String string) {
        int n2 = this.b;
        String string2 = string.substring(0, 1);
        boolean bl2 = string2.toLowerCase().equals(string2.toUpperCase());
        while (!this.isEmpty() && !this.matches(string)) {
            if (bl2) {
                int n3 = this.a.indexOf(string2, this.b) - this.b;
                if (n3 == 0) {
                    ++this.b;
                    continue;
                }
                if (n3 < 0) {
                    this.b = this.a.length();
                    continue;
                }
                this.b += n3;
                continue;
            }
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String consumeToAny(String ... stringArray) {
        int n2 = this.b;
        while (!this.isEmpty() && !this.matchesAny(stringArray)) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String chompTo(String string) {
        String string2 = this.consumeTo(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompToIgnoreCase(String string) {
        String string2 = this.consumeToIgnoreCase(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompBalanced(char c2, char c3) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (!this.isEmpty()) {
            Character c4 = Character.valueOf(this.consume());
            if (n5 == 0 || n5 != 92) {
                if (c4.equals(Character.valueOf(c2))) {
                    ++n4;
                    if (n2 == -1) {
                        n2 = this.b;
                    }
                } else if (c4.equals(Character.valueOf(c3))) {
                    --n4;
                }
            }
            if (n4 > 0 && n5 != 0) {
                n3 = this.b;
            }
            n5 = c4.charValue();
            if (n4 > 0) continue;
        }
        if (n3 >= 0) {
            return this.a.substring(n2, n3);
        }
        return "";
    }

    public static String unescape(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = object[i2];
            if (object3 == 92) {
                if (object2 != 0 && object2 == 92) {
                    stringBuilder.append((char)object3);
                }
            } else {
                stringBuilder.append((char)object3);
            }
            object2 = object3;
        }
        return stringBuilder.toString();
    }

    public boolean consumeWhitespace() {
        boolean bl2 = false;
        while (this.matchesWhitespace()) {
            ++this.b;
            bl2 = true;
        }
        return bl2;
    }

    public String consumeWord() {
        int n2 = this.b;
        while (this.matchesWord()) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String consumeTagName() {
        int n2 = this.b;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny(':', '_', '-'))) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String consumeElementSelector() {
        int n2 = this.b;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('|', '_', '-'))) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String consumeCssIdentifier() {
        int n2 = this.b;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_'))) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String consumeAttributeKey() {
        int n2 = this.b;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_', ':'))) {
            ++this.b;
        }
        return this.a.substring(n2, this.b);
    }

    public String remainder() {
        String string = this.a.substring(this.b, this.a.length());
        this.b = this.a.length();
        return string;
    }

    public String toString() {
        return this.a.substring(this.b);
    }
}

