/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Document$OutputSettings;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.g;
import org.jsoup.nodes.h;
import org.jsoup.parser.Parser;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public abstract class Node
implements Cloneable {
    private static final List f = Collections.emptyList();
    Node a;
    List b;
    Attributes c;
    String d;
    int e;

    protected Node(String string, Attributes attributes) {
        Validate.notNull(string);
        Validate.notNull(attributes);
        this.b = f;
        this.d = string.trim();
        this.c = attributes;
    }

    protected Node(String string) {
        this(string, new Attributes());
    }

    protected Node() {
        this.b = f;
        this.c = null;
    }

    public abstract String nodeName();

    public String attr(String string) {
        Validate.notNull(string);
        if (this.c.hasKey(string)) {
            return this.c.get(string);
        }
        if (string.toLowerCase().startsWith("abs:")) {
            return this.absUrl(string.substring(4));
        }
        return "";
    }

    public Attributes attributes() {
        return this.c;
    }

    public Node attr(String string, String string2) {
        this.c.put(string, string2);
        return this;
    }

    public boolean hasAttr(String string) {
        String string2;
        Validate.notNull(string);
        if (string.startsWith("abs:") && this.c.hasKey(string2 = string.substring(4)) && !this.absUrl(string2).equals("")) {
            return true;
        }
        return this.c.hasKey(string);
    }

    public Node removeAttr(String string) {
        Validate.notNull(string);
        this.c.remove(string);
        return this;
    }

    public String baseUri() {
        return this.d;
    }

    public void setBaseUri(String string) {
        Validate.notNull(string);
        this.traverse(new g(this, string));
    }

    public String absUrl(String string) {
        Validate.notEmpty(string);
        if (!this.hasAttr(string)) {
            return "";
        }
        return StringUtil.resolve(this.d, this.attr(string));
    }

    public Node childNode(int n2) {
        return (Node)this.b.get(n2);
    }

    public List childNodes() {
        return Collections.unmodifiableList(this.b);
    }

    public List childNodesCopy() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.b.size());
        for (Node node : this.b) {
            arrayList.add(node.clone());
        }
        return arrayList;
    }

    public final int childNodeSize() {
        return this.b.size();
    }

    public Node parent() {
        return this.a;
    }

    public final Node parentNode() {
        return this.a;
    }

    public Document ownerDocument() {
        if (this instanceof Document) {
            return (Document)this;
        }
        if (this.a == null) {
            return null;
        }
        return this.a.ownerDocument();
    }

    public void remove() {
        Validate.notNull(this.a);
        this.a.b(this);
    }

    public Node before(String string) {
        Node node = this;
        node.a(node.e, string);
        return this;
    }

    public Node before(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.a(this.e, node);
        return this;
    }

    public Node after(String string) {
        Node node = this;
        node.a(node.e + 1, string);
        return this;
    }

    public Node after(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.a(this.e + 1, node);
        return this;
    }

    private void a(int n2, String object) {
        Validate.notNull(object);
        Validate.notNull(this.a);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        Object object2 = object = Parser.parseFragment((String)object, element, this.baseUri());
        this.a.a(n2, object2.toArray(new Node[object2.size()]));
    }

    public Node wrap(String object) {
        Cloneable cloneable;
        Validate.notEmpty((String)object);
        Node node = this.parent() instanceof Element ? (Element)this.parent() : null;
        object = Parser.parseFragment((String)object, (Element)node, this.baseUri());
        node = (Node)object.get(0);
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        Node node2 = node;
        while ((cloneable = ((Element)node2).children()).size() > 0) {
            node2 = (Element)cloneable.get(0);
        }
        cloneable = node2;
        this.a.a(this, node);
        ((Node)cloneable).a(new Node[]{this});
        if (object.size() > 0) {
            for (int i2 = 0; i2 < object.size(); ++i2) {
                node2 = (Node)object.get(i2);
                node2.a.b(node2);
                ((Element)node).appendChild(node2);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.a);
        Node node = this.b.size() > 0 ? (Node)this.b.get(0) : null;
        Node node2 = this;
        this.a.a(this.e, node2.b.toArray(new Node[node2.childNodeSize()]));
        this.remove();
        return node;
    }

    public void replaceWith(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.a);
        this.a.a(this, node);
    }

    private void a(Node node) {
        if (this.a != null) {
            this.a.b(this);
        }
        this.a = node;
    }

    private void a(Node node, Node node2) {
        Validate.isTrue(node.a == this);
        Validate.notNull(node2);
        if (node2.a != null) {
            node2.a.b(node2);
        }
        int n2 = node.e;
        this.b.set(n2, node2);
        node2.a = this;
        node2.e = n2;
        node.a = null;
    }

    protected final void b(Node node) {
        Validate.isTrue(node.a == this);
        int n2 = node.e;
        this.b.remove(n2);
        this.a(n2);
        node.a = null;
    }

    protected final void a(Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.c(node);
            this.a();
            this.b.add(node);
            node.e = this.b.size() - 1;
        }
    }

    protected final void a(int n2, Node ... nodeArray) {
        Validate.noNullElements(nodeArray);
        for (int i2 = nodeArray.length - 1; i2 >= 0; --i2) {
            Node node = nodeArray[i2];
            this.c(node);
            this.a();
            this.b.add(n2, node);
        }
        this.a(n2);
    }

    protected final void a() {
        if (this.b == f) {
            this.b = new ArrayList(4);
        }
    }

    protected final void c(Node node) {
        if (node.a != null) {
            node.a.b(node);
        }
        node.a(this);
    }

    private void a(int n2) {
        while (n2 < this.b.size()) {
            ((Node)this.b.get((int)n2)).e = n2;
            ++n2;
        }
    }

    public List siblingNodes() {
        if (this.a == null) {
            return Collections.emptyList();
        }
        Object object = this.a.b;
        ArrayList<Node> arrayList = new ArrayList<Node>(object.size() - 1);
        object = object.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            if (node == this) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Node nextSibling() {
        if (this.a == null) {
            return null;
        }
        List list = this.a.b;
        int n2 = this.e + 1;
        if (list.size() > n2) {
            return (Node)list.get(n2);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.a == null) {
            return null;
        }
        if (this.e > 0) {
            return (Node)this.a.b.get(this.e - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.e;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        new NodeTraversor(nodeVisitor).traverse(this);
        return this;
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.a(stringBuilder);
        return stringBuilder.toString();
    }

    protected final void a(StringBuilder stringBuilder) {
        new NodeTraversor(new h(stringBuilder, this.b())).traverse(this);
    }

    final Document$OutputSettings b() {
        if (this.ownerDocument() != null) {
            return this.ownerDocument().outputSettings();
        }
        return new Document("").outputSettings();
    }

    abstract void a(StringBuilder var1, int var2, Document$OutputSettings var3);

    abstract void b(StringBuilder var1, int var2, Document$OutputSettings var3);

    public String toString() {
        return this.outerHtml();
    }

    protected static void c(StringBuilder stringBuilder, int n2, Document$OutputSettings document$OutputSettings) {
        stringBuilder.append("\n").append(StringUtil.padding(n2 * document$OutputSettings.indentAmount()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (Node)object;
        if (this.b != null ? !this.b.equals(((Node)object).b) : ((Node)object).b != null) {
            return false;
        }
        return !(this.c == null ? ((Node)object).c != null : !this.c.equals(((Node)object).c));
    }

    public int hashCode() {
        return (this.b != null ? this.b.hashCode() : 0) * 31 + (this.c != null ? this.c.hashCode() : 0);
    }

    public Node clone() {
        Node node = this.d(null);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.remove();
            for (int i2 = 0; i2 < node2.b.size(); ++i2) {
                Node node3 = ((Node)node2.b.get(i2)).d(node2);
                node2.b.set(i2, node3);
                linkedList.add(node3);
            }
        }
        return node;
    }

    private Node d(Node object) {
        Node node;
        try {
            node = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        node.a = object;
        node.e = object == null ? 0 : this.e;
        node.c = this.c != null ? this.c.clone() : null;
        node.d = this.d;
        node.b = new ArrayList(this.b.size());
        for (Node node2 : this.b) {
            node.b.add(node2);
        }
        return node;
    }
}

