/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Connection$Method;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection$KeyVal;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class FormElement
extends Element {
    private final Elements f = new Elements();

    public FormElement(Tag tag, String string, Attributes attributes) {
        super(tag, string, attributes);
    }

    public Elements elements() {
        return this.f;
    }

    public FormElement addElement(Element element) {
        this.f.add(element);
        return this;
    }

    public Connection submit() {
        String string = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(string, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection$Method connection$Method = this.attr("method").toUpperCase().equals("POST") ? Connection$Method.POST : Connection$Method.GET;
        return Jsoup.connect(string).data(this.formData()).method(connection$Method);
    }

    public List formData() {
        ArrayList<HttpConnection$KeyVal> arrayList = new ArrayList<HttpConnection$KeyVal>();
        for (Element element : this.f) {
            String string;
            if (!element.tag().isFormSubmittable() || element.hasAttr("disabled") || (string = element.attr("name")).length() == 0) continue;
            Object object = element.attr("type");
            if ("select".equals(element.tagName())) {
                object = element.select("option[selected]");
                boolean bl2 = false;
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    Element element2 = (Element)object.next();
                    arrayList.add(HttpConnection$KeyVal.create(string, element2.val()));
                    bl2 = true;
                }
                if (bl2 || (object = element.select("option").first()) == null) continue;
                arrayList.add(HttpConnection$KeyVal.create(string, ((Element)object).val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase((String)object) || "radio".equalsIgnoreCase((String)object)) {
                if (!element.hasAttr("checked")) continue;
                object = element.val().length() > 0 ? element.val() : "on";
                arrayList.add(HttpConnection$KeyVal.create(string, (String)object));
                continue;
            }
            arrayList.add(HttpConnection$KeyVal.create(string, element.val()));
        }
        return arrayList;
    }
}

