/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Document$OutputSettings;
import org.jsoup.nodes.Document$OutputSettings$Syntax;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.d;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator$AllElements;
import org.jsoup.select.Evaluator$Attribute;
import org.jsoup.select.Evaluator$AttributeStarting;
import org.jsoup.select.Evaluator$AttributeWithValue;
import org.jsoup.select.Evaluator$AttributeWithValueContaining;
import org.jsoup.select.Evaluator$AttributeWithValueEnding;
import org.jsoup.select.Evaluator$AttributeWithValueMatching;
import org.jsoup.select.Evaluator$AttributeWithValueNot;
import org.jsoup.select.Evaluator$AttributeWithValueStarting;
import org.jsoup.select.Evaluator$Class;
import org.jsoup.select.Evaluator$ContainsOwnText;
import org.jsoup.select.Evaluator$ContainsText;
import org.jsoup.select.Evaluator$Id;
import org.jsoup.select.Evaluator$IndexEquals;
import org.jsoup.select.Evaluator$IndexGreaterThan;
import org.jsoup.select.Evaluator$IndexLessThan;
import org.jsoup.select.Evaluator$Matches;
import org.jsoup.select.Evaluator$MatchesOwn;
import org.jsoup.select.Evaluator$Tag;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.Selector;

public class Element
extends Node {
    private Tag f;
    private static final Pattern g = Pattern.compile("\\s+");

    public Element(Tag tag, String string, Attributes attributes) {
        super(string, attributes);
        Validate.notNull(tag);
        this.f = tag;
    }

    public Element(Tag tag, String string) {
        this(tag, string, new Attributes());
    }

    public String nodeName() {
        return this.f.getName();
    }

    public String tagName() {
        return this.f.getName();
    }

    public Element tagName(String string) {
        Validate.notEmpty(string, "Tag name must not be empty.");
        this.f = Tag.valueOf(string);
        return this;
    }

    public Tag tag() {
        return this.f;
    }

    public boolean isBlock() {
        return this.f.isBlock();
    }

    public String id() {
        return this.c.get("id");
    }

    public Element attr(String string, String string2) {
        super.attr(string, string2);
        return this;
    }

    public Element attr(String string, boolean bl2) {
        this.c.put(string, bl2);
        return this;
    }

    public Map dataset() {
        return this.c.dataset();
    }

    public final Element parent() {
        return (Element)this.a;
    }

    public Elements parents() {
        Elements elements;
        Elements elements2 = elements = new Elements();
        Element element = this;
        while ((element = element.parent()) != null && !element.tagName().equals("#root")) {
            elements2.add(element);
        }
        return elements;
    }

    public Element child(int n2) {
        return (Element)this.children().get(n2);
    }

    public Elements children() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.b.size());
        for (Node node : this.b) {
            if (!(node instanceof Element)) continue;
            arrayList.add((Element)node);
        }
        return new Elements(arrayList);
    }

    public List textNodes() {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        for (Node node : this.b) {
            if (!(node instanceof TextNode)) continue;
            arrayList.add((TextNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List dataNodes() {
        ArrayList<DataNode> arrayList = new ArrayList<DataNode>();
        for (Node node : this.b) {
            if (!(node instanceof DataNode)) continue;
            arrayList.add((DataNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Element appendChild(Node node) {
        Validate.notNull(node);
        this.c(node);
        this.a();
        this.b.add(node);
        node.e = this.b.size() - 1;
        return this;
    }

    public Element prependChild(Node node) {
        Validate.notNull(node);
        this.a(0, node);
        return this;
    }

    public Element insertChildren(int n2, Collection nodeArray) {
        Validate.notNull(nodeArray, "Children collection to be inserted must not be null.");
        int n3 = this.childNodeSize();
        if (n2 < 0) {
            n2 += n3 + 1;
        }
        Validate.isTrue(n2 >= 0 && n2 <= n3, "Insert position out of bounds.");
        ArrayList arrayList = new ArrayList(nodeArray);
        nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        this.a(n2, nodeArray);
        return this;
    }

    public Element appendElement(String object) {
        object = new Element(Tag.valueOf((String)object), this.baseUri());
        this.appendChild((Node)object);
        return object;
    }

    public Element prependElement(String object) {
        object = new Element(Tag.valueOf((String)object), this.baseUri());
        this.prependChild((Node)object);
        return object;
    }

    public Element appendText(String object) {
        object = new TextNode((String)object, this.baseUri());
        this.appendChild((Node)object);
        return this;
    }

    public Element prependText(String object) {
        object = new TextNode((String)object, this.baseUri());
        this.prependChild((Node)object);
        return this;
    }

    public Element append(String object) {
        Validate.notNull(object);
        Element element = this;
        Object object2 = object = Parser.parseFragment((String)object, element, element.baseUri());
        this.a(object2.toArray(new Node[object2.size()]));
        return this;
    }

    public Element prepend(String object) {
        Validate.notNull(object);
        Element element = this;
        Object object2 = object = Parser.parseFragment((String)object, element, element.baseUri());
        this.a(0, object2.toArray(new Node[object2.size()]));
        return this;
    }

    public Element before(String string) {
        return (Element)super.before(string);
    }

    public Element before(Node node) {
        return (Element)super.before(node);
    }

    public Element after(String string) {
        return (Element)super.after(string);
    }

    public Element after(Node node) {
        return (Element)super.after(node);
    }

    public Element empty() {
        this.b.clear();
        return this;
    }

    public Element wrap(String string) {
        return (Element)super.wrap(string);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            return "#" + this.id();
        }
        StringBuilder stringBuilder = new StringBuilder(this.tagName());
        String string = StringUtil.join(this.classNames(), ".");
        if (string.length() > 0) {
            stringBuilder.append('.').append(string);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return stringBuilder.toString();
        }
        stringBuilder.insert(0, " > ");
        if (this.parent().select(stringBuilder.toString()).size() > 1) {
            stringBuilder.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + stringBuilder.toString();
    }

    public Elements siblingElements() {
        if (this.a == null) {
            return new Elements(0);
        }
        Object object = this.parent().children();
        Elements elements = new Elements(object.size() - 1);
        object = object.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (element == this) continue;
            elements.add(element);
        }
        return elements;
    }

    public Element nextElementSibling() {
        if (this.a == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n2 = Element.a(this, elements);
        Validate.notNull(n2);
        if (elements.size() > n2 + 1) {
            return (Element)elements.get(n2 + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        if (this.a == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n2 = Element.a(this, elements);
        Validate.notNull(n2);
        if (n2 > 0) {
            return (Element)elements.get(n2 - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements elements = this.parent().children();
        if (elements.size() > 1) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        Element element = this;
        return Element.a(element, element.parent().children());
    }

    public Element lastElementSibling() {
        Elements elements = this.parent().children();
        if (elements.size() > 1) {
            Elements elements2 = elements;
            return (Element)elements2.get(elements2.size() - 1);
        }
        return null;
    }

    private static Integer a(Element element, Elements elements) {
        Validate.notNull(element);
        Validate.notNull(elements);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            if ((Element)elements.get(i2) != element) continue;
            return i2;
        }
        return null;
    }

    public Elements getElementsByTag(String string) {
        Validate.notEmpty(string);
        string = string.toLowerCase().trim();
        return Collector.collect(new Evaluator$Tag(string), this);
    }

    public Element getElementById(String object) {
        Validate.notEmpty((String)object);
        object = Collector.collect(new Evaluator$Id((String)object), this);
        if (((ArrayList)object).size() > 0) {
            return (Element)((ArrayList)object).get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String string) {
        Validate.notEmpty(string);
        return Collector.collect(new Evaluator$Class(string), this);
    }

    public Elements getElementsByAttribute(String string) {
        Validate.notEmpty(string);
        string = string.trim().toLowerCase();
        return Collector.collect(new Evaluator$Attribute(string), this);
    }

    public Elements getElementsByAttributeStarting(String string) {
        Validate.notEmpty(string);
        string = string.trim().toLowerCase();
        return Collector.collect(new Evaluator$AttributeStarting(string), this);
    }

    public Elements getElementsByAttributeValue(String string, String string2) {
        return Collector.collect(new Evaluator$AttributeWithValue(string, string2), this);
    }

    public Elements getElementsByAttributeValueNot(String string, String string2) {
        return Collector.collect(new Evaluator$AttributeWithValueNot(string, string2), this);
    }

    public Elements getElementsByAttributeValueStarting(String string, String string2) {
        return Collector.collect(new Evaluator$AttributeWithValueStarting(string, string2), this);
    }

    public Elements getElementsByAttributeValueEnding(String string, String string2) {
        return Collector.collect(new Evaluator$AttributeWithValueEnding(string, string2), this);
    }

    public Elements getElementsByAttributeValueContaining(String string, String string2) {
        return Collector.collect(new Evaluator$AttributeWithValueContaining(string, string2), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, Pattern pattern) {
        return Collector.collect(new Evaluator$AttributeWithValueMatching(string, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, String string2) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: ".concat(String.valueOf(string2)), patternSyntaxException);
        }
        return this.getElementsByAttributeValueMatching(string, pattern);
    }

    public Elements getElementsByIndexLessThan(int n2) {
        return Collector.collect(new Evaluator$IndexLessThan(n2), this);
    }

    public Elements getElementsByIndexGreaterThan(int n2) {
        return Collector.collect(new Evaluator$IndexGreaterThan(n2), this);
    }

    public Elements getElementsByIndexEquals(int n2) {
        return Collector.collect(new Evaluator$IndexEquals(n2), this);
    }

    public Elements getElementsContainingText(String string) {
        return Collector.collect(new Evaluator$ContainsText(string), this);
    }

    public Elements getElementsContainingOwnText(String string) {
        return Collector.collect(new Evaluator$ContainsOwnText(string), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator$Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: ".concat(String.valueOf(string)), patternSyntaxException);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator$MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: ".concat(String.valueOf(string)), patternSyntaxException);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator$AllElements(), this);
    }

    public String text() {
        StringBuilder stringBuilder = new StringBuilder();
        new NodeTraversor(new d(this, stringBuilder)).traverse(this);
        return stringBuilder.toString().trim();
    }

    public String ownText() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        for (Object object : this.b) {
            if (object instanceof TextNode) {
                object = (TextNode)object;
                Element.b(stringBuilder2, (TextNode)object);
                continue;
            }
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            object = stringBuilder2;
            if (!element.f.getName().equals("br") || TextNode.b((StringBuilder)object)) continue;
            ((StringBuilder)object).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private static void b(StringBuilder stringBuilder, TextNode textNode) {
        String string = textNode.getWholeText();
        if (Element.a(textNode.a)) {
            stringBuilder.append(string);
            return;
        }
        StringUtil.appendNormalisedWhitespace(stringBuilder, string, TextNode.b(stringBuilder));
    }

    static boolean a(Node node) {
        if (node != null && node instanceof Element) {
            node = (Element)node;
            return ((Element)node).f.preserveWhitespace() || ((Element)node).parent() != null && ((Element)node).parent().f.preserveWhitespace();
        }
        return false;
    }

    public Element text(String object) {
        Validate.notNull(object);
        this.empty();
        object = new TextNode((String)object, this.d);
        this.appendChild((Node)object);
        return this;
    }

    public boolean hasText() {
        for (Node node : this.b) {
            if (!(node instanceof TextNode ? !((TextNode)node).isBlank() : node instanceof Element && ((Element)node).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : this.b) {
            if (object instanceof DataNode) {
                object = (DataNode)object;
                stringBuilder.append(((DataNode)object).getWholeData());
                continue;
            }
            if (!(object instanceof Element)) continue;
            object = ((Element)object).data();
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set classNames() {
        Object object = g.split(this.className());
        object = new LinkedHashSet<String>(Arrays.asList(object));
        object.remove("");
        return object;
    }

    public Element classNames(Set set) {
        Validate.notNull(set);
        this.c.put("class", StringUtil.join(set, " "));
        return this;
    }

    public boolean hasClass(String string) {
        String[] stringArray = this.c.get("class");
        if (stringArray.equals("") || stringArray.length() < string.length()) {
            return false;
        }
        for (String string2 : g.split((CharSequence)stringArray)) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public Element addClass(String string) {
        Validate.notNull(string);
        Set set = this.classNames();
        set.add(string);
        this.classNames(set);
        return this;
    }

    public Element removeClass(String string) {
        Validate.notNull(string);
        Set set = this.classNames();
        set.remove(string);
        this.classNames(set);
        return this;
    }

    public Element toggleClass(String string) {
        Validate.notNull(string);
        Set set = this.classNames();
        if (set.contains(string)) {
            set.remove(string);
        } else {
            set.add(string);
        }
        this.classNames(set);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String string) {
        if (this.tagName().equals("textarea")) {
            this.text(string);
        } else {
            this.attr("value", string);
        }
        return this;
    }

    final void a(StringBuilder stringBuilder, int n2, Document$OutputSettings document$OutputSettings) {
        if (stringBuilder.length() > 0 && document$OutputSettings.prettyPrint() && (this.f.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || document$OutputSettings.outline())) {
            Element.c(stringBuilder, n2, document$OutputSettings);
        }
        stringBuilder.append("<").append(this.tagName());
        this.c.a(stringBuilder, document$OutputSettings);
        if (this.b.isEmpty() && this.f.isSelfClosing()) {
            if (document$OutputSettings.syntax() == Document$OutputSettings$Syntax.html && this.f.isEmpty()) {
                stringBuilder.append('>');
                return;
            }
            stringBuilder.append(" />");
            return;
        }
        stringBuilder.append(">");
    }

    final void b(StringBuilder stringBuilder, int n2, Document$OutputSettings document$OutputSettings) {
        if (!this.b.isEmpty() || !this.f.isSelfClosing()) {
            if (document$OutputSettings.prettyPrint() && !this.b.isEmpty() && (this.f.formatAsBlock() || document$OutputSettings.outline() && (this.b.size() > 1 || this.b.size() == 1 && !(this.b.get(0) instanceof TextNode)))) {
                Element.c(stringBuilder, n2, document$OutputSettings);
            }
            stringBuilder.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).a(stringBuilder2);
        }
        if (this.b().prettyPrint()) {
            return stringBuilder.toString().trim();
        }
        return stringBuilder.toString();
    }

    public Element html(String string) {
        this.empty();
        this.append(string);
        return this;
    }

    public String toString() {
        return this.outerHtml();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = (Element)object;
        return this.f.equals(((Element)object).f);
    }

    public int hashCode() {
        return super.hashCode() * 31 + (this.f != null ? this.f.hashCode() : 0);
    }

    public Element clone() {
        return (Element)super.clone();
    }

    static /* synthetic */ void a(StringBuilder stringBuilder, TextNode textNode) {
        Element.b(stringBuilder, textNode);
    }

    static /* synthetic */ Tag a(Element element) {
        return element.f;
    }
}

