/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document$OutputSettings;
import org.jsoup.nodes.Document$OutputSettings$Syntax;
import org.jsoup.nodes.Document$QuirksMode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class Document
extends Element {
    private Document$OutputSettings f = new Document$OutputSettings();
    private Document$QuirksMode g = Document$QuirksMode.noQuirks;
    private String h;
    private boolean i = false;

    public Document(String string) {
        super(Tag.valueOf("#root"), string);
        this.h = string;
    }

    public static Document createShell(String object) {
        Validate.notNull(object);
        object = new Document((String)object);
        Element element = ((Element)object).appendElement("html");
        element.appendElement("head");
        element.appendElement("body");
        return object;
    }

    public String location() {
        return this.h;
    }

    public Element head() {
        return this.a("head", (Node)this);
    }

    public Element body() {
        return this.a("body", (Node)this);
    }

    public String title() {
        Element element = this.getElementsByTag("title").first();
        if (element != null) {
            return StringUtil.normaliseWhitespace(element.text()).trim();
        }
        return "";
    }

    public void title(String string) {
        Validate.notNull(string);
        Element element = this.getElementsByTag("title").first();
        if (element == null) {
            this.head().appendElement("title").text(string);
            return;
        }
        element.text(string);
    }

    public Element createElement(String string) {
        return new Element(Tag.valueOf(string), this.baseUri());
    }

    public Document normalise() {
        Element element = this.a("html", (Node)this);
        if (element == null) {
            element = this.appendElement("html");
        }
        if (this.head() == null) {
            element.prependElement("head");
        }
        if (this.body() == null) {
            element.appendElement("body");
        }
        Document document = this;
        document.b(document.head());
        this.b(element);
        Document document2 = this;
        document2.b(document2);
        this.a("head", element);
        this.a("body", element);
        this.c();
        return this;
    }

    private void b(Element element) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : element.b) {
            if (!(node instanceof TextNode) || ((TextNode)(node = (TextNode)node)).isBlank()) continue;
            arrayList.add(node);
        }
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            Node node;
            node = (Node)arrayList.get(i2);
            element.b(node);
            this.body().prependChild(new TextNode(" ", ""));
            this.body().prependChild(node);
        }
    }

    private void a(String object, Element element) {
        object = this.getElementsByTag((String)object);
        Element element2 = ((Elements)object).first();
        if (((ArrayList)object).size() > 1) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i2 = 1; i2 < ((ArrayList)object).size(); ++i2) {
                Node node = (Node)((ArrayList)object).get(i2);
                for (Node node2 : node.b) {
                    arrayList.add(node2);
                }
                node.remove();
            }
            for (Node node : arrayList) {
                element2.appendChild(node);
            }
        }
        if (!((Node)element2.parent()).equals(element)) {
            element.appendChild(element2);
        }
    }

    private Element a(String string, Node object) {
        if (((Node)object).nodeName().equals(string)) {
            return (Element)object;
        }
        for (Node node : ((Node)object).b) {
            if ((node = this.a(string, node)) == null) continue;
            return node;
        }
        return null;
    }

    public String outerHtml() {
        return super.html();
    }

    public Element text(String string) {
        this.body().text(string);
        return this;
    }

    public String nodeName() {
        return "#document";
    }

    public void charset(Charset charset) {
        this.updateMetaCharsetElement(true);
        this.f.charset(charset);
        this.c();
    }

    public Charset charset() {
        return this.f.charset();
    }

    public void updateMetaCharsetElement(boolean bl2) {
        this.i = bl2;
    }

    public boolean updateMetaCharsetElement() {
        return this.i;
    }

    public Document clone() {
        Document document = (Document)super.clone();
        ((Document)super.clone()).f = this.f.clone();
        return document;
    }

    private void c() {
        if (this.i) {
            Object object = this.outputSettings().syntax();
            if (object == Document$OutputSettings$Syntax.html) {
                object = this.select("meta[charset]").first();
                if (object != null) {
                    ((Element)object).attr("charset", this.charset().displayName());
                } else {
                    object = this.head();
                    if (object != null) {
                        ((Element)object).appendElement("meta").attr("charset", this.charset().displayName());
                    }
                }
                this.select("meta[name=charset]").remove();
                return;
            }
            if (object == Document$OutputSettings$Syntax.xml) {
                object = (Node)this.childNodes().get(0);
                if (object instanceof XmlDeclaration) {
                    if (((Node)(object = (XmlDeclaration)object)).attr("declaration").equals("xml")) {
                        ((Node)object).attr("encoding", this.charset().displayName());
                        if (((Node)object).attr("version") != null) {
                            ((Node)object).attr("version", "1.0");
                        }
                        return;
                    }
                    object = new XmlDeclaration("xml", this.d, false);
                    ((Node)object).attr("version", "1.0");
                    ((Node)object).attr("encoding", this.charset().displayName());
                    this.prependChild((Node)object);
                    return;
                }
                object = new XmlDeclaration("xml", this.d, false);
                ((Node)object).attr("version", "1.0");
                ((Node)object).attr("encoding", this.charset().displayName());
                this.prependChild((Node)object);
            }
        }
    }

    public Document$OutputSettings outputSettings() {
        return this.f;
    }

    public Document outputSettings(Document$OutputSettings document$OutputSettings) {
        Validate.notNull(document$OutputSettings);
        this.f = document$OutputSettings;
        return this;
    }

    public Document$QuirksMode quirksMode() {
        return this.g;
    }

    public Document quirksMode(Document$QuirksMode document$QuirksMode) {
        this.g = document$QuirksMode;
        return this;
    }
}

