/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    private static final String[] a = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String join(Collection collection, String string) {
        return StringUtil.join(collection.iterator(), string);
    }

    public static String join(Iterator iterator, String string) {
        if (!iterator.hasNext()) {
            return "";
        }
        CharSequence charSequence = iterator.next().toString();
        if (!iterator.hasNext()) {
            return charSequence;
        }
        charSequence = new StringBuilder(64).append((String)charSequence);
        while (iterator.hasNext()) {
            ((StringBuilder)charSequence).append(string);
            ((StringBuilder)charSequence).append(iterator.next());
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String padding(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n2 < a.length) {
            return a[n2];
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = 32;
        }
        return String.valueOf(cArray);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (StringUtil.isWhitespace(string.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(string.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int n2) {
        return n2 == 32 || n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13;
    }

    public static String normaliseWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringUtil.appendNormalisedWhitespace(stringBuilder, string, false);
        return stringBuilder.toString();
    }

    public static void appendNormalisedWhitespace(StringBuilder stringBuilder, String string, boolean bl2) {
        int n2;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (StringUtil.isWhitespace(n2)) {
                if (bl2 && !bl4 || bl3) continue;
                stringBuilder.append(' ');
                bl3 = true;
                continue;
            }
            stringBuilder.appendCodePoint(n2);
            bl3 = false;
            bl4 = true;
        }
    }

    public static boolean in(String string, String ... stringArray) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String string, String[] stringArray) {
        return Arrays.binarySearch(stringArray, string) >= 0;
    }

    public static URL resolve(URL uRL, String string) {
        if (string.startsWith("?")) {
            string = uRL.getPath() + string;
        }
        if (string.indexOf(46) == 0 && uRL.getFile().indexOf(47) != 0) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/" + uRL.getFile());
        }
        return new URL(uRL, string);
    }

    public static String resolve(String object, String string) {
        try {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                return new URL(string).toExternalForm();
            }
            return StringUtil.resolve((URL)object, string).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }
}

