/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Connection$KeyVal;
import org.jsoup.Connection$Method;
import org.jsoup.Connection$Request;
import org.jsoup.Connection$Response;
import org.jsoup.helper.HttpConnection$KeyVal;
import org.jsoup.helper.HttpConnection$Request;
import org.jsoup.helper.HttpConnection$Response;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

public class HttpConnection
implements Connection {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private Connection$Request a = new HttpConnection$Request(0);
    private Connection$Response b = new HttpConnection$Response();

    public static Connection connect(String string) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(string);
        return httpConnection;
    }

    public static Connection connect(URL uRL) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(uRL);
        return httpConnection;
    }

    private static String c(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(" ", "%20");
    }

    private HttpConnection() {
    }

    public Connection url(URL uRL) {
        this.a.url(uRL);
        return this;
    }

    public Connection url(String string) {
        Validate.notEmpty(string, "Must supply a valid URL");
        try {
            this.a.url(new URL(HttpConnection.c(string)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: ".concat(String.valueOf(string)), malformedURLException);
        }
        return this;
    }

    public Connection userAgent(String string) {
        Validate.notNull(string, "User agent must not be null");
        this.a.header("User-Agent", string);
        return this;
    }

    public Connection timeout(int n2) {
        this.a.timeout(n2);
        return this;
    }

    public Connection maxBodySize(int n2) {
        this.a.maxBodySize(n2);
        return this;
    }

    public Connection followRedirects(boolean bl2) {
        this.a.followRedirects(bl2);
        return this;
    }

    public Connection referrer(String string) {
        Validate.notNull(string, "Referrer must not be null");
        this.a.header("Referer", string);
        return this;
    }

    public Connection method(Connection$Method connection$Method) {
        this.a.method(connection$Method);
        return this;
    }

    public Connection ignoreHttpErrors(boolean bl2) {
        this.a.ignoreHttpErrors(bl2);
        return this;
    }

    public Connection ignoreContentType(boolean bl2) {
        this.a.ignoreContentType(bl2);
        return this;
    }

    public Connection validateTLSCertificates(boolean bl2) {
        this.a.validateTLSCertificates(bl2);
        return this;
    }

    public Connection data(String string, String string2) {
        this.a.data(HttpConnection$KeyVal.create(string, string2));
        return this;
    }

    public Connection data(String string, String string2, InputStream inputStream) {
        this.a.data(HttpConnection$KeyVal.create(string, string2, inputStream));
        return this;
    }

    public Connection data(Map object) {
        Validate.notNull(object, "Data map must not be null");
        for (Map.Entry entry : object.entrySet()) {
            this.a.data(HttpConnection$KeyVal.create((String)entry.getKey(), (String)entry.getValue()));
        }
        return this;
    }

    public Connection data(String ... stringArray) {
        Validate.notNull(stringArray, "Data key value pairs must not be null");
        Validate.isTrue(stringArray.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = stringArray[i2 + 1];
            Validate.notEmpty(string, "Data key must not be empty");
            Validate.notNull(string2, "Data value must not be null");
            this.a.data(HttpConnection$KeyVal.create(string, string2));
        }
        return this;
    }

    public Connection data(Collection object) {
        Validate.notNull(object, "Data collection must not be null");
        object = object.iterator();
        while (object.hasNext()) {
            Connection$KeyVal connection$KeyVal = (Connection$KeyVal)object.next();
            this.a.data(connection$KeyVal);
        }
        return this;
    }

    public Connection header(String string, String string2) {
        this.a.header(string, string2);
        return this;
    }

    public Connection cookie(String string, String string2) {
        this.a.cookie(string, string2);
        return this;
    }

    public Connection cookies(Map object) {
        Validate.notNull(object, "Cookie map must not be null");
        for (Map.Entry entry : object.entrySet()) {
            this.a.cookie((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Connection parser(Parser parser) {
        this.a.parser(parser);
        return this;
    }

    public Document get() {
        this.a.method(Connection$Method.GET);
        this.execute();
        return this.b.parse();
    }

    public Document post() {
        this.a.method(Connection$Method.POST);
        this.execute();
        return this.b.parse();
    }

    public Connection$Response execute() {
        this.b = HttpConnection$Response.a(this.a);
        return this.b;
    }

    public Connection$Request request() {
        return this.a;
    }

    public Connection request(Connection$Request connection$Request) {
        this.a = connection$Request;
        return this;
    }

    public Connection$Response response() {
        return this.b;
    }

    public Connection response(Connection$Response connection$Response) {
        this.b = connection$Response;
        return this;
    }

    public Connection postDataCharset(String string) {
        this.a.postDataCharset(string);
        return this;
    }

    static /* synthetic */ String a(String string) {
        return HttpConnection.c(string);
    }

    static /* synthetic */ String b(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\"", "%22");
    }
}

