/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public final class DataUtil {
    private static final Pattern a = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");
    private static final char[] b = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    private DataUtil() {
    }

    public static Document load(File file, String string, String string2) {
        return DataUtil.a(DataUtil.a(file), string, string2, Parser.htmlParser());
    }

    public static Document load(InputStream inputStream, String string, String string2) {
        return DataUtil.a(DataUtil.a(inputStream, 0), string, string2, Parser.htmlParser());
    }

    public static Document load(InputStream inputStream, String string, String string2, Parser parser) {
        return DataUtil.a(DataUtil.a(inputStream, 0), string, string2, parser);
    }

    static void a(InputStream inputStream, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[131072];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    static Document a(ByteBuffer byteBuffer, String string, String string2, Parser parser) {
        String string3;
        Document document = null;
        if (string == null) {
            string3 = Charset.forName("UTF-8").decode(byteBuffer).toString();
            document = parser.parseInput(string3, string2);
            Element element = document.select("meta[http-equiv=content-type], meta[charset]").first();
            if (element != null) {
                String string4 = null;
                if (element.hasAttr("http-equiv")) {
                    string4 = DataUtil.a(element.attr("content"));
                }
                if (string4 == null && element.hasAttr("charset")) {
                    try {
                        if (Charset.isSupported(element.attr("charset"))) {
                            string4 = element.attr("charset");
                        }
                    }
                    catch (IllegalCharsetNameException illegalCharsetNameException) {
                        string4 = null;
                    }
                }
                if (string4 != null && string4.length() != 0 && !string4.equals("UTF-8")) {
                    string = string4 = string4.trim().replaceAll("[\"']", "");
                    byteBuffer.rewind();
                    string3 = Charset.forName(string4).decode(byteBuffer).toString();
                    document = null;
                }
            }
        } else {
            Validate.notEmpty(string, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
            string3 = Charset.forName(string).decode(byteBuffer).toString();
        }
        if (string3.length() > 0 && string3.charAt(0) == '\ufeff') {
            byteBuffer.rewind();
            string3 = Charset.forName("UTF-8").decode(byteBuffer).toString().substring(1);
            string = "UTF-8";
            document = null;
        }
        if (document == null) {
            document = parser.parseInput(string3, string2);
            document.outputSettings().charset(string);
        }
        return document;
    }

    static ByteBuffer a(InputStream inputStream, int n2) {
        Validate.isTrue(n2 >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean bl2 = n2 > 0;
        byte[] byArray = new byte[131072];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(131072);
        int n3 = n2;
        while ((n2 = inputStream.read(byArray)) != -1) {
            if (bl2) {
                if (n2 > n3) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                    break;
                }
                n3 -= n2;
            }
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private static ByteBuffer a(File object) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile((File)object, "r");
            object = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully((byte[])object);
            object = ByteBuffer.wrap((byte[])object);
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw throwable;
        }
        randomAccessFile.close();
        return object;
    }

    static ByteBuffer a() {
        return ByteBuffer.allocate(0);
    }

    static String a(String object) {
        if (object == null) {
            return null;
        }
        if (((Matcher)(object = a.matcher((CharSequence)object))).find()) {
            if (((String)(object = ((Matcher)object).group(1).trim().replace("charset=", ""))).length() == 0) {
                return null;
            }
            try {
                if (Charset.isSupported((String)object)) {
                    return object;
                }
                if (Charset.isSupported((String)(object = ((String)object).toUpperCase(Locale.ENGLISH)))) {
                    return object;
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                return null;
            }
        }
        return null;
    }

    static String b() {
        StringBuilder stringBuilder = new StringBuilder(32);
        Random random = new Random();
        for (int i2 = 0; i2 < 32; ++i2) {
            stringBuilder.append(b[random.nextInt(b.length)]);
        }
        return stringBuilder.toString();
    }
}

