/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class Field {
    private final java.lang.reflect.Field field;

    Field(java.lang.reflect.Field field) {
        this.field = field;
    }

    public final String getName() {
        return this.field.getName();
    }

    public final Class getType() {
        return this.field.getType();
    }

    public final Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public final boolean isAccessible() {
        return this.field.isAccessible();
    }

    public final void setAccessible(boolean bl2) {
        this.field.setAccessible(bl2);
    }

    public final boolean isDefaultAccess() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public final boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public final boolean isVolatile() {
        return Modifier.isVolatile(this.field.getModifiers());
    }

    public final boolean isSynthetic() {
        return this.field.isSynthetic();
    }

    public final Class getElementType(int n2) {
        Type[] typeArray = this.field.getGenericType();
        if (typeArray instanceof ParameterizedType && (typeArray = ((ParameterizedType)typeArray).getActualTypeArguments()).length - 1 >= n2) {
            Type type = typeArray[n2];
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof GenericArrayType && (type = ((GenericArrayType)type).getGenericComponentType()) instanceof Class) {
                return ArrayReflection.newInstance((Class)type, 0).getClass();
            }
        }
        return null;
    }

    public final boolean isAnnotationPresent(Class clazz) {
        return this.field.isAnnotationPresent(clazz);
    }

    public final Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotationArray = this.field.getDeclaredAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            annotationArray2[i2] = new Annotation(annotationArray[i2]);
        }
        return annotationArray2;
    }

    public final Annotation getDeclaredAnnotation(Class clazz) {
        java.lang.annotation.Annotation[] annotationArray = this.field.getDeclaredAnnotations();
        if (annotationArray == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotationArray) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public final Object get(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException("Object is not an instance of " + this.getDeclaringClass(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Illegal access to field: " + this.getName(), illegalAccessException);
        }
    }

    public final void set(Object object, Object object2) {
        try {
            this.field.set(object, object2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException("Argument not valid for field: " + this.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Illegal access to field: " + this.getName(), illegalAccessException);
        }
    }
}

