/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lzma;

import com.badlogic.gdx.utils.compression.ICodeProgress;
import com.badlogic.gdx.utils.compression.lz.BinTree;
import com.badlogic.gdx.utils.compression.lz.InWindow;
import com.badlogic.gdx.utils.compression.lzma.Base;
import com.badlogic.gdx.utils.compression.lzma.e;
import com.badlogic.gdx.utils.compression.lzma.f;
import com.badlogic.gdx.utils.compression.lzma.g;
import com.badlogic.gdx.utils.compression.lzma.h;
import com.badlogic.gdx.utils.compression.rangecoder.BitTreeEncoder;
import java.io.InputStream;
import java.io.OutputStream;

public class Encoder {
    public static final int EMatchFinderTypeBT2 = 0;
    public static final int EMatchFinderTypeBT4 = 1;
    static final int kIfinityPrice = 0xFFFFFFF;
    static byte[] g_FastPos = new byte[2048];
    int _state = Base.StateInit();
    byte _previousByte;
    int[] _repDistances = new int[4];
    static final int kDefaultDictionaryLogSize = 22;
    static final int kNumFastBytesDefault = 32;
    public static final int kNumLenSpecSymbols = 16;
    static final int kNumOpts = 4096;
    h[] _optimum = new h[4096];
    BinTree _matchFinder = null;
    com.badlogic.gdx.utils.compression.rangecoder.Encoder _rangeEncoder = new com.badlogic.gdx.utils.compression.rangecoder.Encoder();
    short[] _isMatch = new short[192];
    short[] _isRep = new short[12];
    short[] _isRepG0 = new short[12];
    short[] _isRepG1 = new short[12];
    short[] _isRepG2 = new short[12];
    short[] _isRep0Long = new short[192];
    BitTreeEncoder[] _posSlotEncoder = new BitTreeEncoder[4];
    short[] _posEncoders = new short[114];
    BitTreeEncoder _posAlignEncoder = new BitTreeEncoder(4);
    e _lenEncoder = new e(this);
    e _repMatchLenEncoder = new e(this);
    f _literalEncoder = new f(this);
    int[] _matchDistances = new int[548];
    int _numFastBytes = 32;
    int _longestMatchLength;
    int _numDistancePairs;
    int _additionalOffset;
    int _optimumEndIndex;
    int _optimumCurrentIndex;
    boolean _longestMatchWasFound;
    int[] _posSlotPrices = new int[256];
    int[] _distancesPrices = new int[512];
    int[] _alignPrices = new int[16];
    int _alignPriceCount;
    int _distTableSize = 44;
    int _posStateBits = 2;
    int _posStateMask = 3;
    int _numLiteralPosStateBits = 0;
    int _numLiteralContextBits = 3;
    int _dictionarySize = 0x400000;
    int _dictionarySizePrev = -1;
    int _numFastBytesPrev = -1;
    long nowPos64;
    boolean _finished;
    InputStream _inStream;
    int _matchFinderType = 1;
    boolean _writeEndMark = false;
    boolean _needReleaseMFStream = false;
    int[] reps = new int[4];
    int[] repLens = new int[4];
    int backRes;
    long[] processedInSize = new long[1];
    long[] processedOutSize = new long[1];
    boolean[] finished = new boolean[1];
    public static final int kPropSize = 5;
    byte[] properties = new byte[5];
    int[] tempPrices = new int[128];
    int _matchPriceCount;

    static int GetPosSlot(int n2) {
        if (n2 < 2048) {
            return g_FastPos[n2];
        }
        if (n2 < 0x200000) {
            return g_FastPos[n2 >> 10] + 20;
        }
        return g_FastPos[n2 >> 20] + 40;
    }

    static int GetPosSlot2(int n2) {
        if (n2 < 131072) {
            return g_FastPos[n2 >> 6] + 12;
        }
        if (n2 < 0x8000000) {
            return g_FastPos[n2 >> 16] + 32;
        }
        return g_FastPos[n2 >> 26] + 52;
    }

    void BaseInit() {
        this._state = Base.StateInit();
        this._previousByte = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            this._repDistances[i2] = 0;
        }
    }

    void Create() {
        int n2;
        Object object;
        if (this._matchFinder == null) {
            object = new BinTree();
            n2 = 4;
            if (this._matchFinderType == 0) {
                n2 = 2;
            }
            ((BinTree)object).SetType(n2);
            this._matchFinder = object;
        }
        int n3 = this._numLiteralContextBits;
        n2 = this._numLiteralPosStateBits;
        object = this._literalEncoder;
        if (((f)object).a == null || ((f)object).b != n3 || ((f)object).c != n2) {
            ((f)object).c = n2;
            ((f)object).d = (1 << n2) - 1;
            ((f)object).b = n3;
            n2 = 1 << ((f)object).b + ((f)object).c;
            ((f)object).a = new g[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                ((f)object).a[n3] = new g((f)object);
            }
        }
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.Create(this._dictionarySize, 4096, this._numFastBytes, 274);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    public Encoder() {
        int n2;
        for (n2 = 0; n2 < 4096; ++n2) {
            this._optimum[n2] = new h(this);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this._posSlotEncoder[n2] = new BitTreeEncoder(6);
        }
    }

    void SetWriteEndMarkerMode(boolean bl2) {
        this._writeEndMark = bl2;
    }

    void Init() {
        this.BaseInit();
        this._rangeEncoder.Init();
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isMatch);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRep0Long);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRep);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG0);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG1);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG2);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._posEncoders);
        f f2 = this._literalEncoder;
        int n2 = 1 << f2.b + f2.c;
        for (int i2 = 0; i2 < n2; ++i2) {
            com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(f2.a[i2].a);
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            this._posSlotEncoder[i3].Init();
        }
        this._lenEncoder.a(1 << this._posStateBits);
        this._repMatchLenEncoder.a(1 << this._posStateBits);
        this._posAlignEncoder.Init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    int ReadMatchDistances() {
        int n2 = 0;
        this._numDistancePairs = this._matchFinder.GetMatches(this._matchDistances);
        if (this._numDistancePairs > 0 && (n2 = this._matchDistances[this._numDistancePairs - 2]) == this._numFastBytes) {
            n2 += this._matchFinder.GetMatchLen(n2 - 1, this._matchDistances[this._numDistancePairs - 1], 273 - n2);
        }
        ++this._additionalOffset;
        return n2;
    }

    void MovePos(int n2) {
        if (n2 > 0) {
            this._matchFinder.Skip(n2);
            this._additionalOffset += n2;
        }
    }

    int GetRepLen1Price(int n2, int n3) {
        return com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG0[n2]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep0Long[(n2 << 4) + n3]);
    }

    int GetPureRepPrice(int n2, int n3, int n4) {
        if (n2 == 0) {
            n4 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG0[n3]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep0Long[(n3 << 4) + n4]);
        } else {
            n4 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRepG0[n3]);
            n4 = n2 == 1 ? (n4 += com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG1[n3])) : n4 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRepG1[n3]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice(this._isRepG2[n3], n2 - 2);
        }
        return n4;
    }

    int GetRepPrice(int n2, int n3, int n4, int n5) {
        return this._repMatchLenEncoder.a(n3 - 2, n5) + this.GetPureRepPrice(n2, n4, n5);
    }

    int GetPosLenPrice(int n2, int n3, int n4) {
        int n5 = Base.GetLenToPosState(n3);
        n2 = n2 < 128 ? this._distancesPrices[(n5 << 7) + n2] : this._posSlotPrices[(n5 << 6) + Encoder.GetPosSlot2(n2)] + this._alignPrices[n2 & 0xF];
        return n2 + this._lenEncoder.a(n3 - 2, n4);
    }

    int Backward(int n2) {
        int n3;
        this._optimumEndIndex = n2;
        int n4 = this._optimum[n2].g;
        int n5 = this._optimum[n2].h;
        do {
            if (this._optimum[n2].b) {
                this._optimum[n4].a();
                this._optimum[n4].g = n4 - 1;
                if (this._optimum[n2].c) {
                    this._optimum[n4 - 1].b = false;
                    this._optimum[n4 - 1].g = this._optimum[n2].d;
                    this._optimum[n4 - 1].h = this._optimum[n2].e;
                }
            }
            n3 = n4;
            int n6 = n5;
            n5 = this._optimum[n3].h;
            n4 = this._optimum[n3].g;
            this._optimum[n3].h = n6;
            this._optimum[n3].g = n2;
        } while ((n2 = n3) > 0);
        this.backRes = this._optimum[0].h;
        this._optimumCurrentIndex = this._optimum[0].g;
        return this._optimumCurrentIndex;
    }

    /*
     * Unable to fully structure code
     */
    int GetOptimum(int var1_1) {
        if (this._optimumEndIndex != this._optimumCurrentIndex) {
            var2_2 = this._optimum[this._optimumCurrentIndex].g - this._optimumCurrentIndex;
            this.backRes = this._optimum[this._optimumCurrentIndex].h;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].g;
            return var2_2;
        }
        v0 = this;
        v0._optimumEndIndex = 0;
        v0._optimumCurrentIndex = 0;
        if (!this._longestMatchWasFound) {
            var2_3 = this.ReadMatchDistances();
        } else {
            var2_3 = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        var3_6 = this._numDistancePairs;
        if (this._matchFinder.GetNumAvailableBytes() + 1 < 2) {
            this.backRes = -1;
            return 1;
        }
        var4_7 = 0;
        for (var5_8 = 0; var5_8 < 4; ++var5_8) {
            this.reps[var5_8] = this._repDistances[var5_8];
            this.repLens[var5_8] = this._matchFinder.GetMatchLen(-1, this.reps[var5_8], 273);
            if (this.repLens[var5_8] <= this.repLens[var4_7]) continue;
            var4_7 = var5_8;
        }
        if (this.repLens[var4_7] >= this._numFastBytes) {
            this.backRes = var4_7;
            var5_8 = this.repLens[var4_7];
            this.MovePos(var5_8 - 1);
            return var5_8;
        }
        if (var2_3 >= this._numFastBytes) {
            this.backRes = this._matchDistances[var3_6 - 1] + 4;
            this.MovePos(var2_3 - 1);
            return var2_3;
        }
        var5_8 = this._matchFinder.GetIndexByte(-1);
        var6_9 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - 1);
        if (var2_3 < 2 && var5_8 != var6_9 && this.repLens[var4_7] < 2) {
            this.backRes = -1;
            return 1;
        }
        this._optimum[0].a = this._state;
        var7_10 = var1_1 & this._posStateMask;
        this._optimum[1].f = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(this._state << 4) + var7_10]) + this._literalEncoder.a(var1_1, this._previousByte).a(Base.StateIsCharState(this._state) == false, (byte)var6_9, (byte)var5_8);
        this._optimum[1].a();
        var8_11 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(this._state << 4) + var7_10]);
        var9_12 = var8_11 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[this._state]);
        if (var6_9 == var5_8) {
            v1 = this;
            var10_13 = var9_12 + v1.GetRepLen1Price(v1._state, var7_10);
            if (var10_13 < this._optimum[1].f) {
                this._optimum[1].f = var10_13;
                this._optimum[1].b();
            }
        }
        if ((var10_13 = var2_3 >= this.repLens[var4_7] ? var2_3 : this.repLens[var4_7]) < 2) {
            this.backRes = this._optimum[1].h;
            return 1;
        }
        this._optimum[1].g = 0;
        this._optimum[0].i = this.reps[0];
        this._optimum[0].j = this.reps[1];
        this._optimum[0].k = this.reps[2];
        this._optimum[0].l = this.reps[3];
        var4_7 = var10_13;
        do {
            this._optimum[var4_7--].f = 0xFFFFFFF;
        } while (var4_7 >= 2);
        for (var5_8 = 0; var5_8 < 4; ++var5_8) {
            var6_9 = this.repLens[var5_8];
            if (var6_9 < 2) continue;
            var11_14 = var9_12 + this.GetPureRepPrice(var5_8, this._state, var7_10);
            do {
                var12_15 = var11_14 + this._repMatchLenEncoder.a(var6_9 - 2, var7_10);
                var13_16 = this._optimum[var6_9];
                if (var12_15 >= var13_16.f) continue;
                var13_16.f = var12_15;
                var13_16.g = 0;
                var13_16.h = var5_8;
                var13_16.b = false;
            } while (--var6_9 >= 2);
        }
        var6_9 = var8_11 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep[this._state]);
        var4_7 = this.repLens[0] >= 2 ? this.repLens[0] + 1 : 2;
        if (var4_7 <= var2_3) {
            var11_14 = 0;
            while (var4_7 > this._matchDistances[var11_14]) {
                var11_14 += 2;
            }
            while (true) {
                var12_15 = this._matchDistances[var11_14 + 1];
                var13_17 = var6_9 + this.GetPosLenPrice(var12_15, var4_7, var7_10);
                var2_4 = this._optimum[var4_7];
                if (var13_17 < var2_4.f) {
                    var2_4.f = var13_17;
                    var2_4.g = 0;
                    var2_4.h = var12_15 + 4;
                    var2_4.b = false;
                }
                if (var4_7 == this._matchDistances[var11_14] && (var11_14 += 2) == var3_6) break;
                ++var4_7;
            }
        }
        var11_14 = 0;
        block6: while (true) {
            if (++var11_14 == var10_13) {
                return this.Backward(var11_14);
            }
            var12_15 = this.ReadMatchDistances();
            var3_6 = this._numDistancePairs;
            if (var12_15 >= this._numFastBytes) {
                this._longestMatchLength = var12_15;
                this._longestMatchWasFound = true;
                return this.Backward(var11_14);
            }
            ++var1_1;
            var13_18 = this._optimum[var11_14].g;
            if (this._optimum[var11_14].b) {
                --var13_18;
                if (this._optimum[var11_14].c) {
                    var2_5 = this._optimum[this._optimum[var11_14].d].a;
                    var2_5 = this._optimum[var11_14].e < 4 ? Base.StateUpdateRep(var2_5) : Base.StateUpdateMatch(var2_5);
                } else {
                    var2_5 = this._optimum[var13_18].a;
                }
                var2_5 = Base.StateUpdateChar(var2_5);
            } else {
                var2_5 = this._optimum[var13_18].a;
            }
            if (var13_18 == var11_14 - 1) {
                var2_5 = this._optimum[var11_14].h == 0 ? Base.StateUpdateShortRep(var2_5) : Base.StateUpdateChar(var2_5);
            } else {
                if (this._optimum[var11_14].b && this._optimum[var11_14].c) {
                    var13_18 = this._optimum[var11_14].d;
                    var4_7 = this._optimum[var11_14].e;
                    var2_5 = Base.StateUpdateRep(var2_5);
                } else {
                    var4_7 = this._optimum[var11_14].h;
                    var2_5 = var4_7 < 4 ? Base.StateUpdateRep(var2_5) : Base.StateUpdateMatch(var2_5);
                }
                var13_19 = this._optimum[var13_18];
                if (var4_7 < 4) {
                    if (var4_7 == 0) {
                        this.reps[0] = var13_19.i;
                        this.reps[1] = var13_19.j;
                        this.reps[2] = var13_19.k;
                        this.reps[3] = var13_19.l;
                    } else if (var4_7 == 1) {
                        this.reps[0] = var13_19.j;
                        this.reps[1] = var13_19.i;
                        this.reps[2] = var13_19.k;
                        this.reps[3] = var13_19.l;
                    } else if (var4_7 == 2) {
                        this.reps[0] = var13_19.k;
                        this.reps[1] = var13_19.i;
                        this.reps[2] = var13_19.j;
                        this.reps[3] = var13_19.l;
                    } else {
                        this.reps[0] = var13_19.l;
                        this.reps[1] = var13_19.i;
                        this.reps[2] = var13_19.j;
                        this.reps[3] = var13_19.k;
                    }
                } else {
                    this.reps[0] = var4_7 - 4;
                    this.reps[1] = var13_19.i;
                    this.reps[2] = var13_19.j;
                    this.reps[3] = var13_19.k;
                }
            }
            this._optimum[var11_14].a = var2_5;
            this._optimum[var11_14].i = this.reps[0];
            this._optimum[var11_14].j = this.reps[1];
            this._optimum[var11_14].k = this.reps[2];
            this._optimum[var11_14].l = this.reps[3];
            var4_7 = this._optimum[var11_14].f;
            var5_8 = this._matchFinder.GetIndexByte(-1);
            var6_9 = this._matchFinder.GetIndexByte(0 - this.reps[0] - 1 - 1);
            var7_10 = var1_1 & this._posStateMask;
            var13_20 = var4_7 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var2_5 << 4) + var7_10]) + this._literalEncoder.a(var1_1, this._matchFinder.GetIndexByte(-2)).a(Base.StateIsCharState(var2_5) == false, (byte)var6_9, (byte)var5_8);
            var14_21 = this._optimum[var11_14 + 1];
            var15_24 = 0;
            if (var13_20 < var14_21.f) {
                var14_21.f = var13_20;
                var14_21.g = var11_14;
                var14_21.a();
                var15_24 = 1;
            }
            var8_11 = var4_7 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var2_5 << 4) + var7_10]);
            var9_12 = var8_11 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var2_5]);
            if (var6_9 == var5_8 && (var14_21.g >= var11_14 || var14_21.h != 0) && (var16_25 = var9_12 + this.GetRepLen1Price(var2_5, var7_10)) <= var14_21.f) {
                var14_21.f = var16_25;
                var14_21.g = var11_14;
                var14_21.b();
                var15_24 = 1;
            }
            var16_25 = this._matchFinder.GetNumAvailableBytes() + 1;
            var4_7 = var16_25 = Math.min(4095 - var11_14, var16_25);
            if (var16_25 < 2) continue;
            if (var4_7 > this._numFastBytes) {
                var4_7 = this._numFastBytes;
            }
            if (var15_24 == 0 && var6_9 != var5_8 && (var14_22 = this._matchFinder.GetMatchLen(0, this.reps[0], var5_8 = Math.min(var16_25 - 1, this._numFastBytes))) >= 2) {
                var15_24 = Base.StateUpdateChar(var2_5);
                var17_26 = var1_1 + 1 & this._posStateMask;
                var13_20 = var13_20 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var15_24 << 4) + var17_26]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var15_24]);
                var18_27 = var11_14 + 1 + var14_22;
                while (var10_13 < var18_27) {
                    this._optimum[++var10_13].f = 0xFFFFFFF;
                }
                var19_33 = var13_20 + this.GetRepPrice(0, var14_22, var15_24, var17_26);
                var20_34 = this._optimum[var18_27];
                if (var19_33 < var20_34.f) {
                    var20_34.f = var19_33;
                    var20_34.g = var11_14 + 1;
                    var20_34.h = 0;
                    var20_34.b = true;
                    var20_34.c = false;
                }
            }
            var5_8 = 2;
            for (var14_23 = 0; var14_23 < 4; ++var14_23) {
                var15_24 = this._matchFinder.GetMatchLen(-1, this.reps[var14_23], var4_7);
                if (var15_24 < 2) continue;
                var17_26 = var15_24;
                while (true) {
                    if (var10_13 < var11_14 + var15_24) {
                        this._optimum[++var10_13].f = 0xFFFFFFF;
                        continue;
                    }
                    var13_20 = var9_12 + this.GetRepPrice(var14_23, var15_24, var2_5, var7_10);
                    var18_28 = this._optimum[var11_14 + var15_24];
                    if (var13_20 < var18_28.f) {
                        var18_28.f = var13_20;
                        var18_28.g = var11_14;
                        var18_28.h = var14_23;
                        var18_28.b = false;
                    }
                    if (--var15_24 < 2) break;
                }
                var15_24 = var17_26;
                if (var14_23 == 0) {
                    var5_8 = var15_24 + 1;
                }
                if (var15_24 >= var16_25 || (var18_29 = this._matchFinder.GetMatchLen(var15_24, this.reps[var14_23], var13_20 = Math.min(var16_25 - 1 - var15_24, this._numFastBytes))) < 2) continue;
                var19_33 = Base.StateUpdateRep(var2_5);
                var20_35 = var1_1 + var15_24 & this._posStateMask;
                var21_37 = var9_12 + this.GetRepPrice(var14_23, var15_24, var2_5, var7_10) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var19_33 << 4) + var20_35]) + this._literalEncoder.a(var1_1 + var15_24, this._matchFinder.GetIndexByte(var15_24 - 1 - 1)).a(true, this._matchFinder.GetIndexByte(var15_24 - 1 - (this.reps[var14_23] + 1)), this._matchFinder.GetIndexByte(var15_24 - 1));
                var19_33 = Base.StateUpdateChar(var19_33);
                var20_35 = var1_1 + var15_24 + 1 & this._posStateMask;
                var13_20 = var21_37 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var19_33 << 4) + var20_35]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var19_33]);
                var6_9 = var15_24 + 1 + var18_29;
                while (var10_13 < var11_14 + var6_9) {
                    this._optimum[++var10_13].f = 0xFFFFFFF;
                }
                var18_30 = this._optimum[var11_14 + var6_9];
                if ((var13_20 += this.GetRepPrice(0, var18_29, var19_33, var20_35)) >= var18_30.f) continue;
                var18_30.f = var13_20;
                var18_30.g = var11_14 + var15_24 + 1;
                var18_30.h = 0;
                var18_30.b = true;
                var18_30.c = true;
                var18_30.d = var11_14;
                var18_30.e = var14_23;
            }
            if (var12_15 > var4_7) {
                var12_15 = var4_7;
                var3_6 = 0;
                while (var12_15 > this._matchDistances[var3_6]) {
                    var3_6 += 2;
                }
                this._matchDistances[var3_6] = var12_15;
                var3_6 += 2;
            }
            if (var12_15 < var5_8) continue;
            var6_9 = var8_11 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep[var2_5]);
            while (var10_13 < var11_14 + var12_15) {
                this._optimum[++var10_13].f = 0xFFFFFFF;
            }
            var14_23 = 0;
            while (var5_8 > this._matchDistances[var14_23]) {
                var14_23 += 2;
            }
            var15_24 = var5_8;
            while (true) {
                var17_26 = this._matchDistances[var14_23 + 1];
                var13_20 = var6_9 + this.GetPosLenPrice(var17_26, var15_24, var7_10);
                var18_31 = this._optimum[var11_14 + var15_24];
                if (var13_20 < var18_31.f) {
                    var18_31.f = var13_20;
                    var18_31.g = var11_14;
                    var18_31.h = var17_26 + 4;
                    var18_31.b = false;
                }
                if (var15_24 == this._matchDistances[var14_23]) {
                    if (var15_24 < var16_25 && (var20_36 = this._matchFinder.GetMatchLen(var15_24, var17_26, var19_33 = Math.min(var16_25 - 1 - var15_24, this._numFastBytes))) >= 2) {
                        var21_37 = Base.StateUpdateMatch(var2_5);
                        var4_7 = var1_1 + var15_24 & this._posStateMask;
                        var13_20 = var13_20 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var21_37 << 4) + var4_7]) + this._literalEncoder.a(var1_1 + var15_24, this._matchFinder.GetIndexByte(var15_24 - 1 - 1)).a(true, this._matchFinder.GetIndexByte(var15_24 - (var17_26 + 1) - 1), this._matchFinder.GetIndexByte(var15_24 - 1));
                        var21_37 = Base.StateUpdateChar(var21_37);
                        var4_7 = var1_1 + var15_24 + 1 & this._posStateMask;
                        var13_20 = var13_20 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var21_37 << 4) + var4_7]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var21_37]);
                        var18_32 = var15_24 + 1 + var20_36;
                        while (var10_13 < var11_14 + var18_32) {
                            this._optimum[++var10_13].f = 0xFFFFFFF;
                        }
                        var18_31 = this._optimum[var11_14 + var18_32];
                        if ((var13_20 += this.GetRepPrice(0, var20_36, var21_37, var4_7)) < var18_31.f) {
                            var18_31.f = var13_20;
                            var18_31.g = var11_14 + var15_24 + 1;
                            var18_31.h = 0;
                            var18_31.b = true;
                            var18_31.c = true;
                            var18_31.d = var11_14;
                            var18_31.e = var17_26 + 4;
                        }
                    }
                    if ((var14_23 += 2) != var3_6) ** break;
                    continue block6;
                }
                ++var15_24;
            }
            break;
        }
    }

    boolean ChangePair(int n2, int n3) {
        return n2 < 0x2000000 && n3 >= n2 << 7;
    }

    void WriteEndMarker(int n2) {
        if (!this._writeEndMark) {
            return;
        }
        this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + n2, 1);
        this._rangeEncoder.Encode(this._isRep, this._state, 0);
        this._state = Base.StateUpdateMatch(this._state);
        this._lenEncoder.a(this._rangeEncoder, 0, n2);
        n2 = Base.GetLenToPosState(2);
        this._posSlotEncoder[n2].Encode(this._rangeEncoder, 63);
        this._rangeEncoder.EncodeDirectBits(0x3FFFFFF, 26);
        this._posAlignEncoder.ReverseEncode(this._rangeEncoder, 15);
    }

    void Flush(int n2) {
        this.ReleaseMFStream();
        this.WriteEndMarker(n2 & this._posStateMask);
        this._rangeEncoder.FlushData();
        this._rangeEncoder.FlushStream();
    }

    public void CodeOneBlock(long[] lArray, long[] lArray2, boolean[] blArray) {
        int n2;
        int n3;
        lArray[0] = 0L;
        lArray2[0] = 0L;
        blArray[0] = true;
        if (this._inStream != null) {
            this._matchFinder.SetStream(this._inStream);
            ((InWindow)this._matchFinder).Init();
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long l2 = this.nowPos64;
        if (this.nowPos64 == 0L) {
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                Encoder encoder = this;
                encoder.Flush((int)encoder.nowPos64);
                return;
            }
            this.ReadMatchDistances();
            n3 = (int)this.nowPos64 & this._posStateMask;
            this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + n3, 0);
            this._state = Base.StateUpdateChar(this._state);
            n2 = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
            this._literalEncoder.a((int)this.nowPos64, this._previousByte).a(this._rangeEncoder, (byte)n2);
            this._previousByte = n2;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.GetNumAvailableBytes() == 0) {
            Encoder encoder = this;
            encoder.Flush((int)encoder.nowPos64);
            return;
        }
        while (true) {
            int n4;
            int n5;
            Encoder encoder = this;
            n3 = encoder.GetOptimum((int)encoder.nowPos64);
            n2 = this.backRes;
            int n6 = (int)this.nowPos64 & this._posStateMask;
            int n7 = (this._state << 4) + n6;
            if (n3 == 1 && n2 == -1) {
                this._rangeEncoder.Encode(this._isMatch, n7, 0);
                n6 = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
                Object object = this._literalEncoder.a((int)this.nowPos64, this._previousByte);
                if (!Base.StateIsCharState(this._state)) {
                    n5 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    g g2 = object;
                    n4 = n6;
                    object = this._rangeEncoder;
                    g g3 = g2;
                    int n8 = 1;
                    int n9 = 1;
                    for (int i2 = 7; i2 >= 0; --i2) {
                        int n10 = n4 >> i2 & 1;
                        int n11 = n8;
                        if (n9 != 0) {
                            n9 = n5 >> i2 & 1;
                            n11 += n9 + 1 << 8;
                            n9 = n9 == n10 ? 1 : 0;
                        }
                        ((com.badlogic.gdx.utils.compression.rangecoder.Encoder)object).Encode(g3.a, n11, n10);
                        n8 = n8 << 1 | n10;
                    }
                } else {
                    ((g)object).a(this._rangeEncoder, (byte)n6);
                }
                this._previousByte = (byte)n6;
                this._state = Base.StateUpdateChar(this._state);
            } else {
                this._rangeEncoder.Encode(this._isMatch, n7, 1);
                if (n2 < 4) {
                    this._rangeEncoder.Encode(this._isRep, this._state, 1);
                    if (n2 == 0) {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 0);
                        if (n3 == 1) {
                            this._rangeEncoder.Encode(this._isRep0Long, n7, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRep0Long, n7, 1);
                        }
                    } else {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 1);
                        if (n2 == 1) {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 1);
                            this._rangeEncoder.Encode(this._isRepG2, this._state, n2 - 2);
                        }
                    }
                    if (n3 == 1) {
                        this._state = Base.StateUpdateShortRep(this._state);
                    } else {
                        this._repMatchLenEncoder.a(this._rangeEncoder, n3 - 2, n6);
                        this._state = Base.StateUpdateRep(this._state);
                    }
                    n6 = this._repDistances[n2];
                    if (n2 != 0) {
                        for (n7 = n2; n7 > 0; --n7) {
                            this._repDistances[n7] = this._repDistances[n7 - 1];
                        }
                        this._repDistances[0] = n6;
                    }
                } else {
                    this._rangeEncoder.Encode(this._isRep, this._state, 0);
                    this._state = Base.StateUpdateMatch(this._state);
                    this._lenEncoder.a(this._rangeEncoder, n3 - 2, n6);
                    n6 = Encoder.GetPosSlot(n2 -= 4);
                    n7 = Base.GetLenToPosState(n3);
                    this._posSlotEncoder[n7].Encode(this._rangeEncoder, n6);
                    if (n6 >= 4) {
                        n5 = (n6 >> 1) - 1;
                        n7 = (2 | n6 & 1) << n5;
                        n4 = n2 - n7;
                        if (n6 < 14) {
                            BitTreeEncoder.ReverseEncode(this._posEncoders, n7 - n6 - 1, this._rangeEncoder, n5, n4);
                        } else {
                            this._rangeEncoder.EncodeDirectBits(n4 >> 4, n5 - 4);
                            this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n4 & 0xF);
                            ++this._alignPriceCount;
                        }
                    }
                    n5 = n2;
                    for (n7 = 3; n7 > 0; --n7) {
                        this._repDistances[n7] = this._repDistances[n7 - 1];
                    }
                    this._repDistances[0] = n5;
                    ++this._matchPriceCount;
                }
                this._previousByte = this._matchFinder.GetIndexByte(n3 - 1 - this._additionalOffset);
            }
            this._additionalOffset -= n3;
            this.nowPos64 += (long)n3;
            if (this._additionalOffset != 0) continue;
            if (this._matchPriceCount >= 128) {
                this.FillDistancesPrices();
            }
            if (this._alignPriceCount >= 16) {
                this.FillAlignPrices();
            }
            lArray[0] = this.nowPos64;
            lArray2[0] = this._rangeEncoder.GetProcessedSizeAdd();
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                Encoder encoder2 = this;
                encoder2.Flush((int)encoder2.nowPos64);
                return;
            }
            if (this.nowPos64 - l2 >= 4096L) break;
        }
        this._finished = false;
        blArray[0] = false;
    }

    void ReleaseMFStream() {
        if (this._matchFinder != null && this._needReleaseMFStream) {
            this._matchFinder.ReleaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void SetOutStream(OutputStream outputStream) {
        this._rangeEncoder.SetStream(outputStream);
    }

    void ReleaseOutStream() {
        this._rangeEncoder.ReleaseStream();
    }

    void ReleaseStreams() {
        this.ReleaseMFStream();
        this.ReleaseOutStream();
    }

    void SetStreams(InputStream inputStream, OutputStream outputStream, long l2, long l3) {
        this._inStream = inputStream;
        this._finished = false;
        this.Create();
        this.SetOutStream(outputStream);
        this.Init();
        this.FillDistancesPrices();
        this.FillAlignPrices();
        this._lenEncoder.e = this._numFastBytes + 1 - 2;
        this._lenEncoder.b(1 << this._posStateBits);
        this._repMatchLenEncoder.e = this._numFastBytes + 1 - 2;
        this._repMatchLenEncoder.b(1 << this._posStateBits);
        this.nowPos64 = 0L;
    }

    public void Code(InputStream inputStream, OutputStream outputStream, long l2, long l3, ICodeProgress iCodeProgress) {
        this._needReleaseMFStream = false;
        try {
            this.SetStreams(inputStream, outputStream, l2, l3);
            while (true) {
                Encoder encoder = this;
                encoder.CodeOneBlock(encoder.processedInSize, this.processedOutSize, this.finished);
                if (this.finished[0]) {
                    return;
                }
                if (iCodeProgress == null) continue;
                iCodeProgress.SetProgress(this.processedInSize[0], this.processedOutSize[0]);
            }
        }
        finally {
            this.ReleaseStreams();
        }
    }

    public void WriteCoderProperties(OutputStream outputStream) {
        this.properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.properties[i2 + 1] = (byte)(this._dictionarySize >> (i2 << 3));
        }
        outputStream.write(this.properties, 0, 5);
    }

    void FillDistancesPrices() {
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = 4; n5 < 128; ++n5) {
            n4 = Encoder.GetPosSlot(n5);
            n3 = (n4 >> 1) - 1;
            n2 = (2 | n4 & 1) << n3;
            this.tempPrices[n5] = BitTreeEncoder.ReverseGetPrice(this._posEncoders, n2 - n4 - 1, n3, n5 - n2);
        }
        for (n5 = 0; n5 < 4; ++n5) {
            BitTreeEncoder bitTreeEncoder = this._posSlotEncoder[n5];
            n2 = n5 << 6;
            for (n4 = 0; n4 < this._distTableSize; ++n4) {
                this._posSlotPrices[n2 + n4] = bitTreeEncoder.GetPrice(n4);
            }
            for (n4 = 14; n4 < this._distTableSize; ++n4) {
                int n6 = n2 + n4;
                this._posSlotPrices[n6] = this._posSlotPrices[n6] + ((n4 >> 1) - 1 - 4 << 6);
            }
            n4 = n5 << 7;
            for (n3 = 0; n3 < 4; ++n3) {
                this._distancesPrices[n4 + n3] = this._posSlotPrices[n2 + n3];
            }
            while (n3 < 128) {
                this._distancesPrices[n4 + n3] = this._posSlotPrices[n2 + Encoder.GetPosSlot(n3)] + this.tempPrices[n3];
                ++n3;
            }
        }
        this._matchPriceCount = 0;
    }

    void FillAlignPrices() {
        for (int i2 = 0; i2 < 16; ++i2) {
            this._alignPrices[i2] = this._posAlignEncoder.ReverseGetPrice(i2);
        }
        this._alignPriceCount = 0;
    }

    public boolean SetAlgorithm(int n2) {
        return true;
    }

    public boolean SetDictionarySize(int n2) {
        if (n2 <= 0 || n2 > 0x20000000) {
            return false;
        }
        this._dictionarySize = n2;
        int n3 = 0;
        while (n2 > 1 << n3) {
            ++n3;
        }
        this._distTableSize = n3 << 1;
        return true;
    }

    public boolean SetNumFastBytes(int n2) {
        if (n2 < 5 || n2 > 273) {
            return false;
        }
        this._numFastBytes = n2;
        return true;
    }

    public boolean SetMatchFinder(int n2) {
        if (n2 < 0 || n2 > 2) {
            return false;
        }
        int n3 = this._matchFinderType;
        this._matchFinderType = n2;
        if (this._matchFinder != null && n3 != this._matchFinderType) {
            this._dictionarySizePrev = -1;
            this._matchFinder = null;
        }
        return true;
    }

    public boolean SetLcLpPb(int n2, int n3, int n4) {
        if (n3 < 0 || n3 > 4 || n2 < 0 || n2 > 8 || n4 < 0 || n4 > 4) {
            return false;
        }
        this._numLiteralPosStateBits = n3;
        this._numLiteralContextBits = n2;
        this._posStateBits = n4;
        this._posStateMask = (1 << this._posStateBits) - 1;
        return true;
    }

    public void SetEndMarkerMode(boolean bl2) {
        this._writeEndMark = bl2;
    }

    static {
        int n2 = 2;
        Encoder.g_FastPos[0] = 0;
        Encoder.g_FastPos[1] = 1;
        for (int i2 = 2; i2 < 22; ++i2) {
            int n3 = 1 << (i2 >> 1) - 1;
            int n4 = 0;
            while (n4 < n3) {
                Encoder.g_FastPos[n2] = (byte)i2;
                ++n4;
                ++n2;
            }
        }
    }
}

