/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArraySupplier;
import java.util.Comparator;

public class SnapshotArray
extends Array {
    private Object[] snapshot;
    private Object[] recycled;
    private int snapshots;

    public SnapshotArray() {
    }

    public SnapshotArray(Array array) {
        super(array);
    }

    public SnapshotArray(boolean bl2, int n2, ArraySupplier arraySupplier) {
        super(bl2, n2, arraySupplier);
    }

    public SnapshotArray(boolean bl2, int n2, Class clazz) {
        super(bl2, n2, clazz);
    }

    public SnapshotArray(boolean bl2, int n2) {
        super(bl2, n2);
    }

    public SnapshotArray(boolean bl2, Object[] objectArray, int n2, int n3) {
        super(bl2, objectArray, n2, n3);
    }

    public SnapshotArray(ArraySupplier arraySupplier) {
        super(arraySupplier);
    }

    public SnapshotArray(Class clazz) {
        super(clazz);
    }

    public SnapshotArray(int n2) {
        super(n2);
    }

    public SnapshotArray(Object[] objectArray) {
        super(objectArray);
    }

    public Object[] begin() {
        this.modified();
        this.snapshot = this.items;
        ++this.snapshots;
        return this.items;
    }

    public void end() {
        this.snapshots = Math.max(0, this.snapshots - 1);
        if (this.snapshot == null) {
            return;
        }
        if (this.snapshot != this.items && this.snapshots == 0) {
            this.recycled = this.snapshot;
            int n2 = this.recycled.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.recycled[i2] = null;
            }
        }
        this.snapshot = null;
    }

    private void modified() {
        if (this.snapshot == null || this.snapshot != this.items) {
            return;
        }
        if (this.recycled != null && this.recycled.length >= this.size) {
            System.arraycopy(this.items, 0, this.recycled, 0, this.size);
            this.items = this.recycled;
            this.recycled = null;
            return;
        }
        SnapshotArray snapshotArray = this;
        snapshotArray.resize(snapshotArray.items.length);
    }

    @Override
    public void set(int n2, Object object) {
        this.modified();
        super.set(n2, object);
    }

    @Override
    public void insert(int n2, Object object) {
        this.modified();
        super.insert(n2, object);
    }

    @Override
    public void insertRange(int n2, int n3) {
        this.modified();
        super.insertRange(n2, n3);
    }

    @Override
    public void swap(int n2, int n3) {
        this.modified();
        super.swap(n2, n3);
    }

    @Override
    public boolean replaceFirst(Object object, boolean bl2, Object object2) {
        this.modified();
        return super.replaceFirst(object, bl2, object2);
    }

    @Override
    public int replaceAll(Object object, boolean bl2, Object object2) {
        this.modified();
        return super.replaceAll(object, bl2, object2);
    }

    @Override
    public boolean removeValue(Object object, boolean bl2) {
        this.modified();
        return super.removeValue(object, bl2);
    }

    @Override
    public Object removeIndex(int n2) {
        this.modified();
        return super.removeIndex(n2);
    }

    @Override
    public void removeRange(int n2, int n3) {
        this.modified();
        super.removeRange(n2, n3);
    }

    @Override
    public boolean removeAll(Array array, boolean bl2) {
        this.modified();
        return super.removeAll(array, bl2);
    }

    @Override
    public Object pop() {
        this.modified();
        return super.pop();
    }

    @Override
    public void clear() {
        this.modified();
        super.clear();
    }

    @Override
    public void sort() {
        this.modified();
        super.sort();
    }

    @Override
    public void sort(Comparator comparator) {
        this.modified();
        super.sort(comparator);
    }

    @Override
    public void reverse() {
        this.modified();
        super.reverse();
    }

    @Override
    public void shuffle() {
        this.modified();
        super.shuffle();
    }

    @Override
    public void truncate(int n2) {
        this.modified();
        super.truncate(n2);
    }

    @Override
    public Object[] setSize(int n2) {
        this.modified();
        return super.setSize(n2);
    }

    public static SnapshotArray with(Object ... objectArray) {
        return new SnapshotArray(objectArray);
    }
}

