/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.QuickSelect;
import java.util.Comparator;

public class Select {
    private static Select instance;
    private QuickSelect quickSelect;

    public static Select instance() {
        if (instance == null) {
            instance = new Select();
        }
        return instance;
    }

    public Object select(Object[] objectArray, Comparator comparator, int n2, int n3) {
        int n4 = this.selectIndex(objectArray, comparator, n2, n3);
        return objectArray[n4];
    }

    public int selectIndex(Object[] objectArray, Comparator comparator, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            throw new GdxRuntimeException("cannot select from empty array (size < 1)");
        }
        if (n2 > n3) {
            throw new GdxRuntimeException("Kth rank is larger than size. k: " + n2 + ", size: " + n3);
        }
        if (n2 == 1) {
            n4 = this.fastMin(objectArray, comparator, n3);
        } else if (n2 == n3) {
            n4 = this.fastMax(objectArray, comparator, n3);
        } else {
            if (this.quickSelect == null) {
                this.quickSelect = new QuickSelect();
            }
            n4 = this.quickSelect.select(objectArray, comparator, n2, n3);
        }
        return n4;
    }

    private int fastMin(Object[] objectArray, Comparator comparator, int n2) {
        int n3 = 0;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (comparator.compare(objectArray[i2], objectArray[n3]) >= 0) continue;
            n3 = i2;
        }
        return n3;
    }

    private int fastMax(Object[] objectArray, Comparator comparator, int n2) {
        int n3 = 0;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (comparator.compare(objectArray[i2], objectArray[n3]) <= 0) continue;
            n3 = i2;
        }
        return n3;
    }
}

