/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class ReflectionPool
extends Pool {
    private final Constructor constructor;

    public ReflectionPool(Class clazz) {
        this(clazz, 16, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class clazz, int n2) {
        this(clazz, n2, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class clazz, int n2, int n3) {
        super(n2, n3);
        this.constructor = this.findConstructor(clazz);
        if (this.constructor == null) {
            throw new RuntimeException("Class cannot be created (missing no-arg constructor): " + clazz.getName());
        }
    }

    private Constructor findConstructor(Class object) {
        try {
            return ClassReflection.getConstructor((Class)object, null);
        }
        catch (Exception exception) {
            try {
                object = ClassReflection.getDeclaredConstructor((Class)object, null);
                ((Constructor)object).setAccessible(true);
                return object;
            }
            catch (ReflectionException reflectionException) {
                return null;
            }
        }
    }

    @Override
    protected Object newObject() {
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Unable to create new instance: " + this.constructor.getDeclaringClass().getName(), exception);
        }
    }
}

