/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.Queue$QueueIterable;
import com.badlogic.gdx.utils.Queue$QueueIterator;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue
implements Iterable {
    protected Object[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;
    private transient Queue$QueueIterable iterable;

    public Queue() {
        this(16);
    }

    public Queue(int n2) {
        this(n2, ArraySupplier.object());
    }

    public Queue(int n3, Class clazz) {
        this(n3, (int n2) -> (Object[])ArrayReflection.newInstance(clazz, n2));
    }

    public Queue(int n2, ArraySupplier arraySupplier) {
        this.values = (Object[])arraySupplier.get(n2);
    }

    public void addLast(Object object) {
        Object[] objectArray = this.values;
        if (this.size == objectArray.length) {
            this.resize(objectArray.length << 1);
            objectArray = this.values;
        }
        objectArray[this.tail++] = object;
        if (this.tail == objectArray.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void addFirst(Object object) {
        Object[] objectArray = this.values;
        if (this.size == objectArray.length) {
            this.resize(objectArray.length << 1);
            objectArray = this.values;
        }
        int n2 = this.head;
        if (--n2 == -1) {
            n2 = objectArray.length - 1;
        }
        objectArray[n2] = object;
        this.head = n2;
        ++this.size;
    }

    public void ensureCapacity(int n2) {
        if (this.values.length < (n2 = this.size + n2)) {
            this.resize(n2);
        }
    }

    protected void resize(int n2) {
        Object[] objectArray = this.values;
        int n3 = this.head;
        int n4 = this.tail;
        Object[] objectArray2 = Arrays.copyOf(objectArray, n2);
        if (n3 < n4) {
            System.arraycopy(objectArray, n3, objectArray2, 0, n4 - n3);
        } else if (this.size > 0) {
            int n5 = objectArray.length - n3;
            System.arraycopy(objectArray, n3, objectArray2, 0, n5);
            System.arraycopy(objectArray, 0, objectArray2, n5, n4);
        }
        this.values = objectArray2;
        this.head = 0;
        this.tail = this.size;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        Object[] objectArray = this.values;
        Object object = this.values[this.head];
        objectArray[this.head] = null;
        ++this.head;
        if (this.head == objectArray.length) {
            this.head = 0;
        }
        --this.size;
        return object;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        Object[] objectArray = this.values;
        int n2 = this.tail;
        if (--n2 == -1) {
            n2 = objectArray.length - 1;
        }
        Object object = objectArray[n2];
        objectArray[n2] = null;
        this.tail = n2;
        --this.size;
        return object;
    }

    public int indexOf(Object object, boolean n2) {
        if (this.size == 0) {
            return -1;
        }
        Object[] objectArray = this.values;
        int n3 = this.head;
        int n4 = this.tail;
        if (n2 != 0 || object == null) {
            if (n3 < n4) {
                for (n2 = n3; n2 < n4; ++n2) {
                    if (objectArray[n2] != object) continue;
                    return n2 - n3;
                }
            } else {
                int n5 = objectArray.length;
                for (n2 = n3; n2 < n5; ++n2) {
                    if (objectArray[n2] != object) continue;
                    return n2 - n3;
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if (objectArray[n2] != object) continue;
                    return n2 + objectArray.length - n3;
                }
            }
        } else if (n3 < n4) {
            for (n2 = n3; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2 - n3;
            }
        } else {
            int n6 = objectArray.length;
            for (n2 = n3; n2 < n6; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2 - n3;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (!object.equals(objectArray[n2])) continue;
                return n2 + objectArray.length - n3;
            }
        }
        return -1;
    }

    public boolean removeValue(Object object, boolean bl2) {
        int n2 = this.indexOf(object, bl2);
        if (n2 == -1) {
            return false;
        }
        this.removeIndex(n2);
        return true;
    }

    public Object removeIndex(int n2) {
        Object object;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: ".concat(String.valueOf(n2)));
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        Object[] objectArray = this.values;
        int n3 = this.head++;
        int n4 = this.tail--;
        n2 += n3;
        if (n3 < n4) {
            object = objectArray[n2];
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n4 - n2);
            objectArray[n4] = null;
        } else if (n2 >= objectArray.length) {
            object = objectArray[n2 -= objectArray.length];
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n4 - n2);
            --this.tail;
        } else {
            object = objectArray[n2];
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            objectArray[n3] = null;
            if (this.head == objectArray.length) {
                this.head = 0;
            }
        }
        --this.size;
        return object;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object first() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        return this.values[this.head];
    }

    public Object last() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        Object[] objectArray = this.values;
        int n2 = this.tail;
        if (--n2 == -1) {
            n2 = objectArray.length - 1;
        }
        return objectArray[n2];
    }

    public Object get(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: ".concat(String.valueOf(n2)));
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n2 + " >= " + this.size);
        }
        Object[] objectArray = this.values;
        if ((n2 = this.head + n2) >= objectArray.length) {
            n2 -= objectArray.length;
        }
        return objectArray[n2];
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        Object[] objectArray = this.values;
        int n2 = this.head;
        int n3 = this.tail;
        if (n2 < n3) {
            while (n2 < n3) {
                objectArray[n2] = null;
                ++n2;
            }
        } else {
            while (n2 < objectArray.length) {
                objectArray[n2] = null;
                ++n2;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2] = null;
            }
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public Iterator iterator() {
        if (Collections.allocateIterators) {
            return new Queue$QueueIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new Queue$QueueIterable(this);
        }
        return this.iterable.iterator();
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Object[] objectArray = this.values;
        int n2 = this.head;
        int n3 = this.tail;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('[');
        stringBuilder.append(objectArray[n2]);
        n2 = (n2 + 1) % objectArray.length;
        while (n2 != n3) {
            stringBuilder.append(", ").append(objectArray[n2]);
            n2 = (n2 + 1) % objectArray.length;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        Object[] objectArray = this.values;
        int n2 = this.head;
        int n3 = this.tail;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(objectArray[n2]);
        n2 = (n2 + 1) % objectArray.length;
        while (n2 != n3) {
            stringBuilder.append(string).append(objectArray[n2]);
            n2 = (n2 + 1) % objectArray.length;
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = this.size;
        Object[] objectArray = this.values;
        int n3 = this.values.length;
        int n4 = this.head;
        int n5 = n2 + 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[n4];
            n5 *= 31;
            if (object != null) {
                n5 += object.hashCode();
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        return n5;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Queue)) {
            return false;
        }
        object = (Queue)object;
        int n2 = this.size;
        if (((Queue)object).size != n2) {
            return false;
        }
        Object[] objectArray = this.values;
        int n3 = this.values.length;
        Object[] objectArray2 = ((Queue)object).values;
        int n4 = ((Queue)object).values.length;
        int n5 = this.head;
        int n6 = ((Queue)object).head;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[n5];
            Object object3 = objectArray2[n6];
            if (!(object2 != null ? object2.equals(object3) : object3 == null)) {
                return false;
            }
            ++n6;
            if (++n5 == n3) {
                n5 = 0;
            }
            if (n6 != n4) continue;
            n6 = 0;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Queue)) {
            return false;
        }
        object = (Queue)object;
        int n2 = this.size;
        if (((Queue)object).size != n2) {
            return false;
        }
        Object[] objectArray = this.values;
        int n3 = this.values.length;
        Object[] objectArray2 = ((Queue)object).values;
        int n4 = ((Queue)object).values.length;
        int n5 = this.head;
        int n6 = ((Queue)object).head;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[n5] != objectArray2[n6]) {
                return false;
            }
            ++n6;
            if (++n5 == n3) {
                n5 = 0;
            }
            if (n6 != n4) continue;
            n6 = 0;
        }
        return true;
    }
}

