/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DefaultPool;
import com.badlogic.gdx.utils.DefaultPool$PoolSupplier;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entries;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Pools {
    private static final ObjectMap typePools = new ObjectMap();
    private static final ObjectMap supplierPoolsCache = new ObjectMap();

    public static Pool get(Class clazz, int n2) {
        Pool pool = (Pool)typePools.get(clazz);
        if (pool == null) {
            pool = new ReflectionPool(clazz, 4, n2);
            typePools.put(clazz, pool);
        }
        return pool;
    }

    public static Pool get(Class clazz) {
        return Pools.get(clazz, 100);
    }

    public static Pool get(DefaultPool$PoolSupplier defaultPool$PoolSupplier, int n2) {
        Pool pool = (Pool)supplierPoolsCache.get(defaultPool$PoolSupplier.getClass());
        if (pool == null) {
            Class<?> clazz = defaultPool$PoolSupplier.get().getClass();
            pool = (Pool)typePools.get(clazz);
            if (pool == null) {
                pool = new DefaultPool(defaultPool$PoolSupplier, 4, n2);
                typePools.put(clazz, pool);
            }
            supplierPoolsCache.put(defaultPool$PoolSupplier.getClass(), pool);
        }
        return pool;
    }

    public static Pool get(DefaultPool$PoolSupplier defaultPool$PoolSupplier) {
        return Pools.get(defaultPool$PoolSupplier, 100);
    }

    public static void set(Class object, Pool object2) {
        if ((object = (Pool)typePools.put(object, object2)) == null) {
            return;
        }
        object2 = supplierPoolsCache.iterator();
        while (((ObjectMap$Entries)object2).hasNext()) {
            ((ObjectMap$Entries)object2).next();
            if (((ObjectMap$Entries)object2).entry.value != object) continue;
            ((ObjectMap$Entries)object2).remove();
        }
    }

    public static Object obtain(DefaultPool$PoolSupplier defaultPool$PoolSupplier) {
        return Pools.get(defaultPool$PoolSupplier).obtain();
    }

    public static Object obtain(Class clazz) {
        return Pools.get(clazz).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        Pool pool = (Pool)typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Array array) {
        Pools.freeAll(array, false);
    }

    public static void freeAll(Array array, boolean bl2) {
        if (array == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        Pool pool = null;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = array.get(i2);
            if (object == null || pool == null && (pool = (Pool)typePools.get(object.getClass())) == null) continue;
            pool.free(object);
            if (bl2) continue;
            pool = null;
        }
    }

    private Pools() {
    }
}

