/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool$Poolable;

public abstract class Pool {
    public final int max;
    public int peak;
    private final Array freeObjects;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int n2) {
        this(n2, Integer.MAX_VALUE);
    }

    public Pool(int n2, int n3) {
        this.freeObjects = new Array(false, n2);
        this.max = n3;
    }

    protected abstract Object newObject();

    public Object obtain() {
        if (this.freeObjects.size == 0) {
            return this.newObject();
        }
        return this.freeObjects.pop();
    }

    public void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (this.freeObjects.size < this.max) {
            this.freeObjects.add(object);
            this.peak = Math.max(this.peak, this.freeObjects.size);
            this.reset(object);
            return;
        }
        this.discard(object);
    }

    public void fill(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.freeObjects.size >= this.max) continue;
            this.freeObjects.add(this.newObject());
        }
        this.peak = Math.max(this.peak, this.freeObjects.size);
    }

    protected void reset(Object object) {
        if (object instanceof Pool$Poolable) {
            ((Pool$Poolable)object).reset();
        }
    }

    protected void discard(Object object) {
        this.reset(object);
    }

    public void freeAll(Array array) {
        if (array == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        Array array2 = this.freeObjects;
        int n2 = this.max;
        int n3 = array.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = array.get(i2);
            if (object == null) continue;
            if (array2.size < n2) {
                array2.add(object);
                this.reset(object);
                continue;
            }
            this.discard(object);
        }
        this.peak = Math.max(this.peak, array2.size);
    }

    public void clear() {
        Array array = this.freeObjects;
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.discard(array.get(i2));
        }
        array.clear();
    }

    public int getFree() {
        return this.freeObjects.size;
    }
}

