/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;
import com.badlogic.gdx.utils.OrderedSet$OrderedSetIterator;

public class OrderedSet
extends ObjectSet {
    final Array items;
    transient OrderedSet$OrderedSetIterator iterator1;
    transient OrderedSet$OrderedSetIterator iterator2;

    public OrderedSet() {
        this.items = new Array();
    }

    public OrderedSet(int n2, float f2) {
        super(n2, f2);
        this.items = new Array(n2);
    }

    public OrderedSet(int n2) {
        super(n2);
        this.items = new Array(n2);
    }

    public OrderedSet(OrderedSet orderedSet) {
        super(orderedSet);
        this.items = new Array(orderedSet.items);
    }

    @Override
    public boolean add(Object object) {
        if (!super.add(object)) {
            return false;
        }
        this.items.add(object);
        return true;
    }

    public boolean add(Object object, int n2) {
        if (!super.add(object)) {
            int n3 = this.items.indexOf(object, true);
            if (n3 != n2) {
                Array array = this.items;
                array.insert(n2, array.removeIndex(n3));
            }
            return false;
        }
        this.items.insert(n2, object);
        return true;
    }

    public void addAll(OrderedSet orderedSet) {
        ((ObjectSet)this).ensureCapacity(orderedSet.size);
        Object[] objectArray = orderedSet.items.items;
        int n2 = orderedSet.items.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ((ObjectSet)this).add(objectArray[i2]);
        }
    }

    @Override
    public void ensureCapacity(int n2) {
        super.ensureCapacity(n2);
        this.items.ensureCapacity(n2);
    }

    @Override
    public boolean remove(Object object) {
        if (!super.remove(object)) {
            return false;
        }
        this.items.removeValue(object, false);
        return true;
    }

    public Object removeIndex(int n2) {
        Object object = this.items.removeIndex(n2);
        super.remove(object);
        return object;
    }

    public boolean alter(Object object, Object object2) {
        if (this.contains(object2)) {
            return false;
        }
        if (!super.remove(object)) {
            return false;
        }
        super.add(object2);
        this.items.set(this.items.indexOf(object, false), object2);
        return true;
    }

    public boolean alterIndex(int n2, Object object) {
        if (n2 < 0 || n2 >= this.size || this.contains(object)) {
            return false;
        }
        OrderedSet orderedSet = this;
        super.remove(orderedSet.items.get(n2));
        super.add(object);
        this.items.set(n2, object);
        return true;
    }

    @Override
    public void clear(int n2) {
        this.items.clear();
        super.clear(n2);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    public Array orderedItems() {
        return this.items;
    }

    @Override
    public Object first() {
        return this.items.first();
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        Object[] objectArray = this.items.items;
        int n3 = this.items.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            n2 += object.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectSet)) {
            return false;
        }
        object = (ObjectSet)object;
        if (((ObjectSet)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.items.items;
        int n2 = this.items.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] == null || ((ObjectSet)object).contains(objectArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public OrderedSet$OrderedSetIterator iterator() {
        if (Collections.allocateIterators) {
            return new OrderedSet$OrderedSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSet$OrderedSetIterator(this);
            this.iterator2 = new OrderedSet$OrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            ((ObjectSet$ObjectSetIterator)this.iterator1).reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        ((ObjectSet$ObjectSetIterator)this.iterator2).reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        Object[] objectArray = this.items.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(objectArray[0]);
        for (int i2 = 1; i2 < this.size; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(objectArray[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String toString(String string) {
        return this.items.toString(string);
    }

    public static OrderedSet with(Object ... objectArray) {
        OrderedSet orderedSet = new OrderedSet();
        orderedSet.addAll(objectArray);
        return orderedSet;
    }
}

