/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;
import com.badlogic.gdx.utils.OrderedSet;
import java.util.NoSuchElementException;

public class OrderedSet$OrderedSetIterator
extends ObjectSet$ObjectSetIterator {
    private Array items;

    public OrderedSet$OrderedSetIterator(OrderedSet orderedSet) {
        super(orderedSet);
        this.items = orderedSet.items;
    }

    @Override
    public void reset() {
        this.nextIndex = 0;
        this.hasNext = this.set.size > 0;
    }

    @Override
    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        Object object = this.items.get(this.nextIndex);
        ++this.nextIndex;
        this.hasNext = this.nextIndex < this.set.size;
        return object;
    }

    @Override
    public void remove() {
        if (this.nextIndex < 0) {
            throw new IllegalStateException("next must be called before remove.");
        }
        --this.nextIndex;
        ((OrderedSet)this.set).removeIndex(this.nextIndex);
    }

    @Override
    public Array toArray(Array array) {
        array.addAll(this.items, this.nextIndex, this.items.size - this.nextIndex);
        this.nextIndex = this.items.size;
        this.hasNext = false;
        return array;
    }

    @Override
    public Array toArray() {
        return ((ObjectSet$ObjectSetIterator)this).toArray(new Array(true, this.set.size - this.nextIndex));
    }
}

