/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectSet$ObjectSetIterator;
import java.util.Arrays;

public class ObjectSet
implements Iterable {
    public int size;
    Object[] keyTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;
    private transient ObjectSet$ObjectSetIterator iterator1;
    private transient ObjectSet$ObjectSetIterator iterator2;

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int n2) {
        this(n2, 0.8f);
    }

    public ObjectSet(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: ".concat(String.valueOf(f2)));
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
    }

    public ObjectSet(ObjectSet objectSet) {
        this((int)((float)objectSet.keyTable.length * objectSet.loadFactor), objectSet.loadFactor);
        System.arraycopy(objectSet.keyTable, 0, this.keyTable, 0, objectSet.keyTable.length);
        this.size = objectSet.size;
    }

    protected int place(Object object) {
        return (int)((long)object.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] objectArray = this.keyTable;
        int n2 = this.place(object);
        Object object2;
        while ((object2 = objectArray[n2]) != null) {
            if (object2.equals(object)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public boolean add(Object object) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            return false;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        if (++this.size >= this.threshold) {
            ObjectSet objectSet = this;
            objectSet.resize(objectSet.keyTable.length << 1);
        }
        return true;
    }

    public void addAll(Array array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array array, int n2, int n3) {
        if (n2 + n3 > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n2 + " + " + n3 + " <= " + array.size);
        }
        this.addAll(array.items, n2, n3);
    }

    public boolean addAll(Object ... objectArray) {
        return this.addAll(objectArray, 0, objectArray.length);
    }

    public boolean addAll(Object[] objectArray, int n2, int n3) {
        this.ensureCapacity(n3);
        int n4 = this.size;
        n3 = n2 + n3;
        while (n2 < n3) {
            this.add(objectArray[n2]);
            ++n2;
        }
        return n4 != this.size;
    }

    public void addAll(ObjectSet objectArray) {
        this.ensureCapacity(objectArray.size);
        for (Object object : objectArray.keyTable) {
            if (object == null) continue;
            this.add(object);
        }
    }

    private void addResize(Object object) {
        Object[] objectArray = this.keyTable;
        int n2 = this.place(object);
        while (true) {
            if (objectArray[n2] == null) {
                objectArray[n2] = object;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public boolean remove(Object object) {
        int n2 = this.locateKey(object);
        if (n2 < 0) {
            return false;
        }
        Object[] objectArray = this.keyTable;
        int n3 = this.mask;
        int n4 = n2 + 1 & n3;
        while ((object = objectArray[n4]) != null) {
            int n5 = this.place(object);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                objectArray[n2] = object;
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        objectArray[n2] = null;
        --this.size;
        return true;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean contains(Object object) {
        return this.locateKey(object) >= 0;
    }

    public Object get(Object object) {
        int n2 = this.locateKey(object);
        if (n2 < 0) {
            return null;
        }
        return this.keyTable[n2];
    }

    public Object first() {
        Object[] objectArray = this.keyTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] == null) continue;
            return objectArray[i2];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    private void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        Object[] objectArray = this.keyTable;
        this.keyTable = new Object[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object = objectArray[n2];
                if (object == null) continue;
                this.addResize(object);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        for (Object object : this.keyTable) {
            if (object == null) continue;
            n2 += object.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectSet)) {
            return false;
        }
        object = (ObjectSet)object;
        if (((ObjectSet)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.keyTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] == null || ((ObjectSet)object).contains(objectArray[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{" + this.toString(", ") + '}';
    }

    public String toString(String string) {
        Object object;
        if (this.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        Object[] objectArray = this.keyTable;
        int n2 = this.keyTable.length;
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(object == this ? "(this)" : object);
            break;
        }
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(object == this ? "(this)" : object);
        }
        return stringBuilder.toString();
    }

    public ObjectSet$ObjectSetIterator iterator() {
        if (Collections.allocateIterators) {
            return new ObjectSet$ObjectSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSet$ObjectSetIterator(this);
            this.iterator2 = new ObjectSet$ObjectSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static ObjectSet with(Object ... objectArray) {
        ObjectSet objectSet = new ObjectSet();
        objectSet.addAll(objectArray);
        return objectSet;
    }

    static int tableSize(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        int n3 = MathUtils.nextPowerOfTwo(Math.max(2, (int)Math.ceil((float)n2 / f2)));
        if (n3 > 0x40000000) {
            throw new IllegalArgumentException("The required capacity is too large: ".concat(String.valueOf(n2)));
        }
        return n3;
    }
}

