/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectSet$ObjectSetIterator
implements Iterable,
Iterator {
    public boolean hasNext;
    final ObjectSet set;
    int nextIndex;
    int currentIndex;
    boolean valid = true;

    public ObjectSet$ObjectSetIterator(ObjectSet objectSet) {
        this.set = objectSet;
        this.reset();
    }

    public void reset() {
        this.currentIndex = -1;
        this.nextIndex = -1;
        this.findNextIndex();
    }

    private void findNextIndex() {
        Object[] objectArray = this.set.keyTable;
        int n2 = this.set.keyTable.length;
        while (++this.nextIndex < n2) {
            if (objectArray[this.nextIndex] == null) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    @Override
    public void remove() {
        Object object;
        int n2 = this.currentIndex;
        if (n2 < 0) {
            throw new IllegalStateException("next must be called before remove.");
        }
        Object[] objectArray = this.set.keyTable;
        int n3 = this.set.mask;
        int n4 = n2 + 1 & n3;
        while ((object = objectArray[n4]) != null) {
            int n5 = this.set.place(object);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                objectArray[n2] = object;
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        objectArray[n2] = null;
        --this.set.size;
        if (n2 != this.currentIndex) {
            --this.nextIndex;
        }
        this.currentIndex = -1;
    }

    @Override
    public boolean hasNext() {
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        return this.hasNext;
    }

    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        Object object = this.set.keyTable[this.nextIndex];
        this.currentIndex = this.nextIndex;
        this.findNextIndex();
        return object;
    }

    public ObjectSet$ObjectSetIterator iterator() {
        return this;
    }

    public Array toArray(Array array) {
        while (this.hasNext) {
            array.add(this.next());
        }
        return array;
    }

    public Array toArray() {
        return this.toArray(new Array(true, this.set.size));
    }
}

