/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.ObjectIntMap$Entries;
import com.badlogic.gdx.utils.ObjectIntMap$Keys;
import com.badlogic.gdx.utils.ObjectIntMap$Values;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;

public class ObjectIntMap
implements Iterable {
    public int size;
    Object[] keyTable;
    int[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;
    transient ObjectIntMap$Entries entries1;
    transient ObjectIntMap$Entries entries2;
    transient ObjectIntMap$Values values1;
    transient ObjectIntMap$Values values2;
    transient ObjectIntMap$Keys keys1;
    transient ObjectIntMap$Keys keys2;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectIntMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: ".concat(String.valueOf(f2)));
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
    }

    public ObjectIntMap(ObjectIntMap objectIntMap) {
        this((int)((float)objectIntMap.keyTable.length * objectIntMap.loadFactor), objectIntMap.loadFactor);
        System.arraycopy(objectIntMap.keyTable, 0, this.keyTable, 0, objectIntMap.keyTable.length);
        System.arraycopy(objectIntMap.valueTable, 0, this.valueTable, 0, objectIntMap.valueTable.length);
        this.size = objectIntMap.size;
    }

    protected int place(Object object) {
        return (int)((long)object.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] objectArray = this.keyTable;
        int n2 = this.place(object);
        Object object2;
        while ((object2 = objectArray[n2]) != null) {
            if (object2.equals(object)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public void put(Object object, int n2) {
        int n3 = this.locateKey(object);
        if (n3 >= 0) {
            this.valueTable[n3] = n2;
            return;
        }
        n3 = -(n3 + 1);
        this.keyTable[n3] = object;
        this.valueTable[n3] = n2;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
    }

    public int put(Object object, int n2, int n3) {
        int n4 = this.locateKey(object);
        if (n4 >= 0) {
            int n5 = this.valueTable[n4];
            this.valueTable[n4] = n2;
            return n5;
        }
        n4 = -(n4 + 1);
        this.keyTable[n4] = object;
        this.valueTable[n4] = n2;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
        return n3;
    }

    public void putAll(ObjectIntMap object) {
        this.ensureCapacity(((ObjectIntMap)object).size);
        Object[] objectArray = ((ObjectIntMap)object).keyTable;
        object = ((ObjectIntMap)object).valueTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[i2];
            if (object2 == null) continue;
            this.put(object2, (int)object[i2]);
        }
    }

    private void putResize(Object object, int n2) {
        Object[] objectArray = this.keyTable;
        int n3 = this.place(object);
        while (true) {
            if (objectArray[n3] == null) {
                objectArray[n3] = object;
                this.valueTable[n3] = n2;
                return;
            }
            n3 = n3 + 1 & this.mask;
        }
    }

    public int get(Object object, int n2) {
        int n3 = this.locateKey(object);
        if (n3 < 0) {
            return n2;
        }
        return this.valueTable[n3];
    }

    public int getAndIncrement(Object object, int n2, int n3) {
        int n4 = this.locateKey(object);
        if (n4 >= 0) {
            int n5 = this.valueTable[n4];
            int n6 = n4;
            this.valueTable[n6] = this.valueTable[n6] + n3;
            return n5;
        }
        n4 = -(n4 + 1);
        this.keyTable[n4] = object;
        this.valueTable[n4] = n2 + n3;
        if (++this.size >= this.threshold) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.resize(objectIntMap.keyTable.length << 1);
        }
        return n2;
    }

    public int remove(Object object, int n2) {
        int n3 = this.locateKey(object);
        if (n3 < 0) {
            return n2;
        }
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n4 = this.valueTable[n3];
        int n5 = this.mask;
        int n6 = n3 + 1 & n5;
        while ((object = objectArray[n6]) != null) {
            int n7 = this.place(object);
            if ((n6 - n7 & n5) > (n3 - n7 & n5)) {
                objectArray[n3] = object;
                nArray[n3] = nArray[n6];
                n3 = n6;
            }
            n6 = n6 + 1 & n5;
        }
        objectArray[n3] = null;
        --this.size;
        return n4;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(int n2) {
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            if (objectArray[i2] == null || nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.locateKey(object) >= 0;
    }

    public Object findKey(int n2) {
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            Object object = objectArray[i2];
            if (object == null || nArray[i2] != n2) continue;
            return object;
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    final void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        this.keyTable = new Object[n2];
        this.valueTable = new int[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object = objectArray[n2];
                if (object == null) continue;
                this.putResize(object, nArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            n2 += object.hashCode() + nArray[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectIntMap)) {
            return false;
        }
        object = (ObjectIntMap)object;
        if (((ObjectIntMap)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[i2];
            if (object2 == null) continue;
            int n3 = ((ObjectIntMap)object).get(object2, 0);
            if (n3 == 0 && !((ObjectIntMap)object).containsKey(object2)) {
                return false;
            }
            if (n3 == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String string, boolean bl2) {
        Object object;
        if (this.size == 0) {
            if (bl2) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl2) {
            stringBuilder.append('{');
        }
        Object[] objectArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
            break;
        }
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
        }
        if (bl2) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public ObjectIntMap$Entries iterator() {
        return this.entries();
    }

    public ObjectIntMap$Entries entries() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new ObjectIntMap$Entries(this);
            this.entries2 = new ObjectIntMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public ObjectIntMap$Values values() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new ObjectIntMap$Values(this);
            this.values2 = new ObjectIntMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public ObjectIntMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new ObjectIntMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new ObjectIntMap$Keys(this);
            this.keys2 = new ObjectIntMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

