/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ObjectFloatMap$Entries;
import com.badlogic.gdx.utils.ObjectFloatMap$Keys;
import com.badlogic.gdx.utils.ObjectFloatMap$Values;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;

public class ObjectFloatMap
implements Iterable {
    public int size;
    Object[] keyTable;
    float[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;
    transient ObjectFloatMap$Entries entries1;
    transient ObjectFloatMap$Entries entries2;
    transient ObjectFloatMap$Values values1;
    transient ObjectFloatMap$Values values2;
    transient ObjectFloatMap$Keys keys1;
    transient ObjectFloatMap$Keys keys2;

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectFloatMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: ".concat(String.valueOf(f2)));
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n2];
        this.valueTable = new float[n2];
    }

    public ObjectFloatMap(ObjectFloatMap objectFloatMap) {
        this((int)Math.floor((float)objectFloatMap.keyTable.length * objectFloatMap.loadFactor), objectFloatMap.loadFactor);
        System.arraycopy(objectFloatMap.keyTable, 0, this.keyTable, 0, objectFloatMap.keyTable.length);
        System.arraycopy(objectFloatMap.valueTable, 0, this.valueTable, 0, objectFloatMap.valueTable.length);
        this.size = objectFloatMap.size;
    }

    protected int place(Object object) {
        return (int)((long)object.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] objectArray = this.keyTable;
        int n2 = this.place(object);
        Object object2;
        while ((object2 = objectArray[n2]) != null) {
            if (object2.equals(object)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public void put(Object object, float f2) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            this.valueTable[n2] = f2;
            return;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        this.valueTable[n2] = f2;
        if (++this.size >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
    }

    public float put(Object object, float f2, float f3) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            float f4 = this.valueTable[n2];
            this.valueTable[n2] = f2;
            return f4;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        this.valueTable[n2] = f2;
        if (++this.size >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
        return f3;
    }

    public void putAll(ObjectFloatMap object) {
        this.ensureCapacity(((ObjectFloatMap)object).size);
        Object[] objectArray = ((ObjectFloatMap)object).keyTable;
        object = ((ObjectFloatMap)object).valueTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[i2];
            if (object2 == null) continue;
            this.put(object2, (float)object[i2]);
        }
    }

    private void putResize(Object object, float f2) {
        Object[] objectArray = this.keyTable;
        int n2 = this.place(object);
        while (true) {
            if (objectArray[n2] == null) {
                objectArray[n2] = object;
                this.valueTable[n2] = f2;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public float get(Object object, float f2) {
        int n2 = this.locateKey(object);
        if (n2 < 0) {
            return f2;
        }
        return this.valueTable[n2];
    }

    public float getAndIncrement(Object object, float f2, float f3) {
        int n2 = this.locateKey(object);
        if (n2 >= 0) {
            float f4 = this.valueTable[n2];
            int n3 = n2;
            this.valueTable[n3] = this.valueTable[n3] + f3;
            return f4;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = object;
        this.valueTable[n2] = f2 + f3;
        if (++this.size >= this.threshold) {
            ObjectFloatMap objectFloatMap = this;
            objectFloatMap.resize(objectFloatMap.keyTable.length << 1);
        }
        return f2;
    }

    public float remove(Object object, float f2) {
        int n2 = this.locateKey(object);
        if (n2 < 0) {
            return f2;
        }
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        float f3 = this.valueTable[n2];
        int n3 = this.mask;
        int n4 = n2 + 1 & n3;
        while ((object = objectArray[n4]) != null) {
            int n5 = this.place(object);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                objectArray[n2] = object;
                fArray[n2] = fArray[n4];
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        objectArray[n2] = null;
        --this.size;
        return f3;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(float f2) {
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            if (objectArray[i2] == null || fArray[i2] != f2) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(float f2, float f3) {
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            if (objectArray[i2] == null || !(Math.abs(fArray[i2] - f2) <= f3)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.locateKey(object) >= 0;
    }

    public Object findKey(float f2) {
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            Object object = objectArray[i2];
            if (object == null || fArray[i2] != f2) continue;
            return object;
        }
        return null;
    }

    public Object findKey(float f2, float f3) {
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            Object object = objectArray[i2];
            if (object == null || !(Math.abs(fArray[i2] - f2) <= f3)) continue;
            return object;
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    final void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new Object[n2];
        this.valueTable = new float[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object = objectArray[n2];
                if (object == null) continue;
                this.putResize(object, fArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            n2 += object.hashCode() + NumberUtils.floatToRawIntBits(fArray[i2]);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectFloatMap)) {
            return false;
        }
        object = (ObjectFloatMap)object;
        if (((ObjectFloatMap)object).size != this.size) {
            return false;
        }
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray[i2];
            if (object2 == null) continue;
            float f2 = ((ObjectFloatMap)object).get(object2, 0.0f);
            if (f2 == 0.0f && !((ObjectFloatMap)object).containsKey(object2)) {
                return false;
            }
            if (f2 == fArray[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String string, boolean bl2) {
        Object object;
        if (this.size == 0) {
            if (bl2) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl2) {
            stringBuilder.append('{');
        }
        Object[] objectArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = objectArray.length;
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
            break;
        }
        while (n2-- > 0) {
            object = objectArray[n2];
            if (object == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(object);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
        }
        if (bl2) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public ObjectFloatMap$Entries iterator() {
        return this.entries();
    }

    public ObjectFloatMap$Entries entries() {
        if (Collections.allocateIterators) {
            return new ObjectFloatMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new ObjectFloatMap$Entries(this);
            this.entries2 = new ObjectFloatMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public ObjectFloatMap$Values values() {
        if (Collections.allocateIterators) {
            return new ObjectFloatMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new ObjectFloatMap$Values(this);
            this.values2 = new ObjectFloatMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public ObjectFloatMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new ObjectFloatMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new ObjectFloatMap$Keys(this);
            this.keys2 = new ObjectFloatMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

