/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.d.a;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntMap$Entry;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.IntSet$IntSetIterator;
import com.badlogic.gdx.utils.Json$Serializable;
import com.badlogic.gdx.utils.Json$Serializer;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonValue$PrettyPrintSettings;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.JsonWriter$OutputType;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.LongMap$Entry;
import com.badlogic.gdx.utils.ObjectFloatMap;
import com.badlogic.gdx.utils.ObjectFloatMap$Entry;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectIntMap$Entry;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.Queue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.e;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Json {
    private static final boolean debug = false;
    private JsonWriter writer;
    private JsonReader reader = new JsonReader();
    private String typeName = "class";
    private boolean usePrototypes = true;
    private JsonWriter$OutputType outputType;
    private boolean quoteLongValues;
    private boolean ignoreUnknownFields;
    private boolean ignoreDeprecated;
    private boolean readDeprecated;
    private boolean enumNames = true;
    private boolean sortFields;
    private Json$Serializer defaultSerializer;
    private final ObjectMap typeToFields = new ObjectMap();
    private final ObjectMap tagToClass = new ObjectMap();
    private final ObjectMap classToTag = new ObjectMap();
    private final ObjectMap classToSerializer = new ObjectMap();
    private final ObjectMap classToDefaultValues = new ObjectMap();
    private final Object[] equals1 = new Object[]{null};
    private final Object[] equals2 = new Object[]{null};

    public Json() {
        this.outputType = JsonWriter$OutputType.minimal;
    }

    public Json(JsonWriter$OutputType jsonWriter$OutputType) {
        this.outputType = jsonWriter$OutputType;
    }

    public void setIgnoreUnknownFields(boolean bl2) {
        this.ignoreUnknownFields = bl2;
    }

    public boolean getIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreDeprecated(boolean bl2) {
        this.ignoreDeprecated = bl2;
    }

    public void setReadDeprecated(boolean bl2) {
        this.readDeprecated = bl2;
    }

    public void setOutputType(JsonWriter$OutputType jsonWriter$OutputType) {
        this.outputType = jsonWriter$OutputType;
    }

    public void setQuoteLongValues(boolean bl2) {
        this.quoteLongValues = bl2;
    }

    public void setEnumNames(boolean bl2) {
        this.enumNames = bl2;
    }

    public void addClassTag(String string, Class clazz) {
        this.tagToClass.put(string, clazz);
        this.classToTag.put(clazz, string);
    }

    public Class getClass(String string) {
        return (Class)this.tagToClass.get(string);
    }

    public String getTag(Class clazz) {
        return (String)this.classToTag.get(clazz);
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setDefaultSerializer(Json$Serializer json$Serializer) {
        this.defaultSerializer = json$Serializer;
    }

    public void setSerializer(Class clazz, Json$Serializer json$Serializer) {
        this.classToSerializer.put(clazz, json$Serializer);
    }

    public Json$Serializer getSerializer(Class clazz) {
        return (Json$Serializer)this.classToSerializer.get(clazz);
    }

    public void setUsePrototypes(boolean bl2) {
        this.usePrototypes = bl2;
    }

    public void setElementType(Class clazz, String string, Class clazz2) {
        e e2 = (e)this.getFields(clazz).get(string);
        if (e2 == null) {
            throw new SerializationException("Field not found: " + string + " (" + clazz.getName() + ")");
        }
        e2.b = clazz2;
    }

    public void setDeprecated(Class clazz, String string, boolean bl2) {
        e e2 = (e)this.getFields(clazz).get(string);
        if (e2 == null) {
            throw new SerializationException("Field not found: " + string + " (" + clazz.getName() + ")");
        }
        e2.c = bl2;
    }

    public void setSortFields(boolean bl2) {
        this.sortFields = bl2;
    }

    protected void sortFields(Class clazz, Array array) {
        if (this.sortFields) {
            array.sort();
        }
    }

    private OrderedMap getFields(Class clazz) {
        Class clazz2;
        Iterable iterable = (OrderedMap)this.typeToFields.get(clazz);
        if (iterable != null) {
            return iterable;
        }
        iterable = new Array();
        for (clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            ((Array)iterable).add(clazz2);
        }
        clazz2 = new ArrayList();
        for (int i2 = ((Array)iterable).size - 1; i2 >= 0; --i2) {
            Collections.addAll(clazz2, ClassReflection.getDeclaredFields((Class)((Array)iterable).get(i2)));
        }
        OrderedMap orderedMap = new OrderedMap(((ArrayList)((Object)clazz2)).size());
        int n2 = ((ArrayList)((Object)clazz2)).size();
        for (int i3 = 0; i3 < n2; ++i3) {
            Field field = (Field)((ArrayList)((Object)clazz2)).get(i3);
            if (field.isTransient() || field.isStatic() || field.isSynthetic()) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (RuntimeException runtimeException) {
                    continue;
                }
            }
            ((ObjectMap)orderedMap).put(field.getName(), new e(field));
        }
        this.sortFields(clazz, orderedMap.keys);
        this.typeToFields.put(clazz, orderedMap);
        return orderedMap;
    }

    public String toJson(Object object) {
        Object object2 = object;
        return this.toJson(object2, (Class)(object2 == null ? null : object.getClass()), (Class)null);
    }

    public String toJson(Object object, Class clazz) {
        return this.toJson(object, clazz, (Class)null);
    }

    public String toJson(Object object, Class clazz, Class clazz2) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, clazz, clazz2, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, a a2) {
        Object object2 = object;
        this.toJson(object2, object2 == null ? null : object.getClass(), null, a2);
    }

    public void toJson(Object object, Class clazz, a a2) {
        this.toJson(object, clazz, null, a2);
    }

    public void toJson(Object object, Class clazz, Class clazz2, a a2) {
        Writer writer = null;
        try {
            writer = a2.d("UTF-8");
            this.toJson(object, clazz, clazz2, writer);
            return;
        }
        catch (Exception exception) {
            throw new SerializationException("Error writing file: ".concat(String.valueOf(a2)), exception);
        }
        finally {
            StreamUtils.closeQuietly(writer);
        }
    }

    public void toJson(Object object, Writer writer) {
        Object object2 = object;
        this.toJson(object2, object2 == null ? null : object.getClass(), null, writer);
    }

    public void toJson(Object object, Class clazz, Writer writer) {
        this.toJson(object, clazz, null, writer);
    }

    public void toJson(Object object, Class clazz, Class clazz2, Writer writer) {
        this.setWriter(writer);
        try {
            this.writeValue(object, clazz, clazz2);
            return;
        }
        finally {
            StreamUtils.closeQuietly(this.writer);
            this.writer = null;
        }
    }

    public void setWriter(Writer writer) {
        if (!(writer instanceof JsonWriter)) {
            writer = new JsonWriter(writer);
        }
        this.writer = (JsonWriter)writer;
        this.writer.setOutputType(this.outputType);
        this.writer.setQuoteLongValues(this.quoteLongValues);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    public void setReader(JsonReader jsonReader) {
        this.reader = jsonReader;
    }

    public JsonReader getReader() {
        return this.reader;
    }

    public void writeFields(Object object) {
        Class<?> clazz = object.getClass();
        Object[] objectArray = this.getDefaultValues(clazz);
        OrderedMap orderedMap = this.getFields(clazz);
        int n2 = 0;
        Array array = orderedMap.orderedKeys();
        int n3 = array.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2;
            Object object3;
            e e2 = (e)orderedMap.get((String)array.get(i2));
            if (this.ignoreDeprecated && e2.c) continue;
            Field field = e2.a;
            try {
                object3 = field.get(object);
                if (objectArray != null) {
                    object2 = objectArray[n2++];
                    if (object3 == null && object2 == null) continue;
                    if (object3 != null && object2 != null) {
                        if (object3.equals(object2)) continue;
                        if (object3.getClass().isArray() && object2.getClass().isArray()) {
                            this.equals1[0] = object3;
                            this.equals2[0] = object2;
                            if (Arrays.deepEquals(this.equals1, this.equals2)) continue;
                        }
                    }
                }
                this.writer.name(field.getName());
                this.writeValue(object3, field.getType(), e2.b);
                continue;
            }
            catch (ReflectionException reflectionException) {
                throw new SerializationException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", reflectionException);
            }
            catch (SerializationException serializationException) {
                object3 = serializationException;
                serializationException.addTrace(field + " (" + clazz.getName() + ")");
                throw object3;
            }
            catch (Exception exception) {
                object2 = new SerializationException(exception);
                ((SerializationException)object2).addTrace(field + " (" + clazz.getName() + ")");
                throw object2;
            }
        }
    }

    private Object[] getDefaultValues(Class clazz) {
        Object object;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(clazz)) {
            return (Object[])this.classToDefaultValues.get(clazz);
        }
        try {
            object = this.newInstance(clazz);
        }
        catch (Exception exception) {
            this.classToDefaultValues.put(clazz, null);
            return null;
        }
        OrderedMap orderedMap = this.getFields(clazz);
        Object[] objectArray = new Object[orderedMap.size];
        this.classToDefaultValues.put(clazz, objectArray);
        int n2 = 0;
        Array array = orderedMap.orderedKeys();
        int n3 = array.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = (e)orderedMap.get((String)array.get(i2));
            if (this.ignoreDeprecated && ((e)object2).c) continue;
            object2 = ((e)object2).a;
            try {
                objectArray[n2++] = ((Field)object2).get(object);
                continue;
            }
            catch (ReflectionException reflectionException) {
                throw new SerializationException("Error accessing field: " + ((Field)object2).getName() + " (" + clazz.getName() + ")", reflectionException);
            }
            catch (SerializationException serializationException) {
                object = serializationException;
                serializationException.addTrace(object2 + " (" + clazz.getName() + ")");
                throw object;
            }
            catch (RuntimeException runtimeException) {
                SerializationException serializationException = new SerializationException(runtimeException);
                serializationException.addTrace(object2 + " (" + clazz.getName() + ")");
                throw serializationException;
            }
        }
        return objectArray;
    }

    public void writeField(Object object, String string) {
        String string2 = string;
        this.writeField(object, string2, string2, null);
    }

    public void writeField(Object object, String string, Class clazz) {
        String string2 = string;
        this.writeField(object, string2, string2, clazz);
    }

    public void writeField(Object object, String string, String string2) {
        this.writeField(object, string, string2, null);
    }

    public void writeField(Object object, String object2, String string, Class clazz) {
        Class<?> clazz2 = object.getClass();
        e e2 = (e)this.getFields(clazz2).get(object2);
        if (e2 == null) {
            throw new SerializationException("Field not found: " + (String)object2 + " (" + clazz2.getName() + ")");
        }
        object2 = e2.a;
        if (clazz == null) {
            clazz = e2.b;
        }
        try {
            this.writer.name(string);
            this.writeValue(((Field)object2).get(object), ((Field)object2).getType(), clazz);
            return;
        }
        catch (ReflectionException reflectionException) {
            throw new SerializationException("Error accessing field: " + ((Field)object2).getName() + " (" + clazz2.getName() + ")", reflectionException);
        }
        catch (SerializationException serializationException) {
            object = serializationException;
            serializationException.addTrace(object2 + " (" + clazz2.getName() + ")");
            throw object;
        }
        catch (Exception exception) {
            SerializationException serializationException = new SerializationException(exception);
            serializationException.addTrace(object2 + " (" + clazz2.getName() + ")");
            throw serializationException;
        }
    }

    public void writeValue(String string, Object object) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        if (object == null) {
            this.writeValue(object, null, null);
            return;
        }
        Object object2 = object;
        this.writeValue(object2, object2.getClass(), null);
    }

    public void writeValue(String string, Object object, Class clazz) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        this.writeValue(object, clazz, null);
    }

    public void writeValue(String string, Object object, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        this.writeValue(object, clazz, clazz2);
    }

    public void writeValue(Object object) {
        if (object == null) {
            this.writeValue(object, null, null);
            return;
        }
        Object object2 = object;
        this.writeValue(object2, object2.getClass(), null);
    }

    public void writeValue(Object object, Class clazz) {
        this.writeValue(object, clazz, null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeValue(Object object, Class iterator, Class clazz) {
        try {
            if (object == null) {
                this.writer.value(null);
                return;
            }
            if (iterator != null && ((Class)((Object)iterator)).isPrimitive() || iterator == String.class || iterator == Integer.class || iterator == Boolean.class || iterator == Float.class || iterator == Long.class || iterator == Double.class || iterator == Short.class || iterator == Byte.class || iterator == Character.class) {
                this.writer.value(object);
                return;
            }
            Class<?> clazz22 = object.getClass();
            if (clazz22.isPrimitive() || clazz22 == String.class || clazz22 == Integer.class || clazz22 == Boolean.class || clazz22 == Float.class || clazz22 == Long.class || clazz22 == Double.class || clazz22 == Short.class || clazz22 == Byte.class || clazz22 == Character.class) {
                this.writeObjectStart(clazz22, null);
                this.writeValue("value", object);
                this.writeObjectEnd();
                return;
            }
            if (object instanceof Json$Serializable) {
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                ((Json$Serializable)object).write(this);
                this.writeObjectEnd();
                return;
            }
            Json$Serializer json$Serializer = (Json$Serializer)this.classToSerializer.get(clazz22);
            if (json$Serializer != null) {
                json$Serializer.write(this, object, (Class)((Object)iterator));
                return;
            }
            if (object instanceof Array) {
                void i3;
                if (iterator != null && clazz22 != iterator && clazz22 != Array.class) {
                    throw new SerializationException("Serialization of an Array other than the known type is not supported.\nKnown type: " + iterator + "\nActual type: " + clazz22);
                }
                this.writeArrayStart();
                iterator = (Array)object;
                boolean i2 = false;
                int n2 = ((Array)((Object)iterator)).size;
                while (i3 < n2) {
                    this.writeValue(((Array)((Object)iterator)).get((int)i3), clazz, null);
                    ++i3;
                }
                this.writeArrayEnd();
                return;
            }
            if (object instanceof Queue) {
                void i5;
                if (iterator != null && clazz22 != iterator && clazz22 != Queue.class) {
                    throw new SerializationException("Serialization of a Queue other than the known type is not supported.\nKnown type: " + iterator + "\nActual type: " + clazz22);
                }
                this.writeArrayStart();
                iterator = (Queue)object;
                boolean i4 = false;
                int n3 = ((Queue)((Object)iterator)).size;
                while (i5 < n3) {
                    this.writeValue(((Queue)((Object)iterator)).get((int)i5), clazz, null);
                    ++i5;
                }
                this.writeArrayEnd();
                return;
            }
            if (object instanceof Collection) {
                if (this.typeName != null && clazz22 != ArrayList.class && (iterator == null || iterator != clazz22)) {
                    this.writeObjectStart(clazz22, (Class)((Object)iterator));
                    this.writeArrayStart("items");
                    for (Object e2 : (Collection)object) {
                        this.writeValue(e2, clazz, null);
                    }
                    this.writeArrayEnd();
                    this.writeObjectEnd();
                    return;
                }
                this.writeArrayStart();
                for (Object e3 : (Collection)object) {
                    this.writeValue(e3, clazz, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (clazz22.isArray()) {
                void var4_18;
                if (clazz == null) {
                    clazz = clazz22.getComponentType();
                }
                int n4 = ArrayReflection.getLength(object);
                this.writeArrayStart();
                boolean bl2 = false;
                while (var4_18 < n4) {
                    this.writeValue(ArrayReflection.get(object, (int)var4_18), clazz, null);
                    ++var4_18;
                }
                this.writeArrayEnd();
                return;
            }
            if (object instanceof ObjectMap) {
                if (iterator == null) {
                    iterator = ObjectMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (ObjectMap$Entry objectMap$Entry : ((ObjectMap)object).entries()) {
                    this.writer.name(this.convertToString(objectMap$Entry.key));
                    this.writeValue(objectMap$Entry.value, clazz, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof ObjectIntMap) {
                if (iterator == null) {
                    iterator = ObjectIntMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (ObjectIntMap$Entry objectIntMap$Entry : ((ObjectIntMap)object).entries()) {
                    this.writer.name(this.convertToString(objectIntMap$Entry.key));
                    this.writeValue(objectIntMap$Entry.value, Integer.class);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof ObjectFloatMap) {
                if (iterator == null) {
                    iterator = ObjectFloatMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (ObjectFloatMap$Entry objectFloatMap$Entry : ((ObjectFloatMap)object).entries()) {
                    this.writer.name(this.convertToString(objectFloatMap$Entry.key));
                    this.writeValue(Float.valueOf(objectFloatMap$Entry.value), Float.class);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof ObjectSet) {
                if (iterator == null) {
                    iterator = ObjectSet.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                this.writer.name("values");
                this.writeArrayStart();
                for (Object e4 : (ObjectSet)object) {
                    this.writeValue(e4, clazz, null);
                }
                this.writeArrayEnd();
                this.writeObjectEnd();
                return;
            }
            if (object instanceof IntMap) {
                if (iterator == null) {
                    iterator = IntMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (IntMap$Entry intMap$Entry : ((IntMap)object).entries()) {
                    this.writer.name(String.valueOf(intMap$Entry.key));
                    this.writeValue(intMap$Entry.value, clazz, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof LongMap) {
                if (iterator == null) {
                    iterator = LongMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (LongMap$Entry longMap$Entry : ((LongMap)object).entries()) {
                    this.writer.name(String.valueOf(longMap$Entry.key));
                    this.writeValue(longMap$Entry.value, clazz, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof IntSet) {
                if (iterator == null) {
                    iterator = IntSet.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                this.writer.name("values");
                this.writeArrayStart();
                iterator = ((IntSet)object).iterator();
                while (((IntSet$IntSetIterator)((Object)iterator)).hasNext) {
                    this.writeValue(((IntSet$IntSetIterator)((Object)iterator)).next(), Integer.class, null);
                }
                this.writeArrayEnd();
                this.writeObjectEnd();
                return;
            }
            if (object instanceof ArrayMap) {
                void var4_32;
                if (iterator == null) {
                    iterator = ArrayMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                iterator = (ArrayMap)object;
                boolean bl3 = false;
                int n5 = ((ArrayMap)((Object)iterator)).size;
                while (var4_32 < n5) {
                    this.writer.name(this.convertToString(((ArrayMap)((Object)iterator)).keys[var4_32]));
                    this.writeValue(((ArrayMap)((Object)iterator)).values[var4_32], clazz, null);
                    ++var4_32;
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof Map) {
                if (iterator == null) {
                    iterator = HashMap.class;
                }
                this.writeObjectStart(clazz22, (Class)((Object)iterator));
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), clazz, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (ClassReflection.isAssignableFrom(Enum.class, clazz22)) {
                void var4_36;
                if (clazz22.getEnumConstants() == null) {
                    Class<?> clazz2 = clazz22.getSuperclass();
                }
                if (this.typeName != null && (iterator == null || iterator != var4_36)) {
                    this.writeObjectStart((Class)var4_36, null);
                    this.writer.name("value");
                    this.writer.value(this.convertToString((Enum)object));
                    this.writeObjectEnd();
                    return;
                }
                this.writer.value(this.convertToString((Enum)object));
                return;
            }
            this.writeObjectStart(clazz22, (Class)((Object)iterator));
            this.writeFields(object);
            this.writeObjectEnd();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart(String string) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String string, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        this.writeObjectStart(clazz, clazz2);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart(Class clazz, Class clazz2) {
        try {
            this.writer.object();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        if (clazz2 == null || clazz2 != clazz) {
            this.writeType(clazz);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeArrayStart(String string) {
        try {
            this.writer.name(string);
            this.writer.array();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeType(Class clazz) {
        if (this.typeName == null) {
            return;
        }
        String string = this.getTag(clazz);
        if (string == null) {
            string = clazz.getName();
        }
        try {
            this.writer.set(this.typeName, string);
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public Object fromJson(Class clazz, Reader reader) {
        return this.readValue(clazz, null, this.reader.parse(reader));
    }

    public Object fromJson(Class clazz, Class clazz2, Reader reader) {
        return this.readValue(clazz, clazz2, this.reader.parse(reader));
    }

    public Object fromJson(Class clazz, InputStream inputStream) {
        return this.readValue(clazz, null, this.reader.parse(inputStream));
    }

    public Object fromJson(Class clazz, Class clazz2, InputStream inputStream) {
        return this.readValue(clazz, clazz2, this.reader.parse(inputStream));
    }

    public Object fromJson(Class clazz, a a2) {
        try {
            return this.readValue(clazz, null, this.reader.parse(a2));
        }
        catch (Exception exception) {
            throw new SerializationException("Error reading file: ".concat(String.valueOf(a2)), exception);
        }
    }

    public Object fromJson(Class clazz, Class clazz2, a a2) {
        try {
            return this.readValue(clazz, clazz2, this.reader.parse(a2));
        }
        catch (Exception exception) {
            throw new SerializationException("Error reading file: ".concat(String.valueOf(a2)), exception);
        }
    }

    public Object fromJson(Class clazz, char[] cArray, int n2, int n3) {
        return this.readValue(clazz, null, this.reader.parse(cArray, n2, n3));
    }

    public Object fromJson(Class clazz, Class clazz2, char[] cArray, int n2, int n3) {
        return this.readValue(clazz, clazz2, this.reader.parse(cArray, n2, n3));
    }

    public Object fromJson(Class clazz, String string) {
        return this.readValue(clazz, null, this.reader.parse(string));
    }

    public Object fromJson(Class clazz, Class clazz2, String string) {
        return this.readValue(clazz, clazz2, this.reader.parse(string));
    }

    public void readField(Object object, String string, JsonValue jsonValue) {
        String string2 = string;
        this.readField(object, string2, string2, null, jsonValue);
    }

    public void readField(Object object, String string, Class clazz, JsonValue jsonValue) {
        String string2 = string;
        this.readField(object, string2, string2, clazz, jsonValue);
    }

    public void readField(Object object, String string, String string2, JsonValue jsonValue) {
        this.readField(object, string, string2, null, jsonValue);
    }

    public void readField(Object object, String object2, String string, Class clazz, JsonValue jsonValue) {
        Class<?> clazz2 = object.getClass();
        e e2 = (e)this.getFields(clazz2).get(object2);
        if (e2 == null) {
            throw new SerializationException("Field not found: " + (String)object2 + " (" + clazz2.getName() + ")");
        }
        object2 = e2.a;
        if (clazz == null) {
            clazz = e2.b;
        }
        this.readField(object, (Field)object2, string, clazz, jsonValue);
    }

    public void readField(Object object, Field field, String object2, Class clazz, JsonValue jsonValue) {
        if ((object2 = jsonValue.get((String)object2)) == null) {
            return;
        }
        try {
            field.set(object, this.readValue(field.getType(), clazz, (JsonValue)object2));
            return;
        }
        catch (ReflectionException reflectionException) {
            throw new SerializationException("Error accessing field: " + field.getName() + " (" + field.getDeclaringClass().getName() + ")", reflectionException);
        }
        catch (SerializationException serializationException) {
            object = serializationException;
            serializationException.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw object;
        }
        catch (RuntimeException runtimeException) {
            SerializationException serializationException = new SerializationException(runtimeException);
            serializationException.addTrace(((JsonValue)object2).trace());
            serializationException.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw serializationException;
        }
    }

    public void readFields(Object object, JsonValue jsonValue) {
        Class<?> clazz = object.getClass();
        OrderedMap orderedMap = this.getFields(clazz);
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            Object object2;
            e e2 = (e)orderedMap.get(jsonValue.name().replace(" ", "_"));
            if (e2 == null) {
                if (!(jsonValue.name.equals(this.typeName) || this.ignoreUnknownFields || this.ignoreUnknownField(clazz, jsonValue.name))) {
                    object2 = new SerializationException("Field not found: " + jsonValue.name + " (" + clazz.getName() + ")");
                    ((SerializationException)object2).addTrace(jsonValue.trace());
                    throw object2;
                }
            } else if (!this.ignoreDeprecated || this.readDeprecated || !e2.c) {
                object2 = e2.a;
                try {
                    ((Field)object2).set(object, this.readValue(((Field)object2).getType(), e2.b, jsonValue));
                }
                catch (ReflectionException reflectionException) {
                    throw new SerializationException("Error accessing field: " + ((Field)object2).getName() + " (" + clazz.getName() + ")", reflectionException);
                }
                catch (SerializationException serializationException) {
                    object = serializationException;
                    serializationException.addTrace(((Field)object2).getName() + " (" + clazz.getName() + ")");
                    throw object;
                }
                catch (RuntimeException runtimeException) {
                    SerializationException serializationException = new SerializationException(runtimeException);
                    serializationException.addTrace(jsonValue.trace());
                    serializationException.addTrace(((Field)object2).getName() + " (" + clazz.getName() + ")");
                    throw serializationException;
                }
            }
            jsonValue = jsonValue.next;
        }
    }

    protected boolean ignoreUnknownField(Class clazz, String string) {
        return false;
    }

    public Object readValue(String string, Class clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue.get(string));
    }

    public Object readValue(String object, Class clazz, Object object2, JsonValue jsonValue) {
        if ((object = jsonValue.get((String)object)) == null) {
            return object2;
        }
        return this.readValue(clazz, null, (JsonValue)object);
    }

    public Object readValue(String string, Class clazz, Class clazz2, JsonValue jsonValue) {
        return this.readValue(clazz, clazz2, jsonValue.get(string));
    }

    public Object readValue(String object, Class clazz, Class clazz2, Object object2, JsonValue jsonValue) {
        object = jsonValue.get((String)object);
        return this.readValue(clazz, clazz2, object2, (JsonValue)object);
    }

    public Object readValue(Class clazz, Class clazz2, Object object, JsonValue jsonValue) {
        if (jsonValue == null) {
            return object;
        }
        return this.readValue(clazz, clazz2, jsonValue);
    }

    public Object readValue(Class clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue);
    }

    public Object readValue(Class clazz, Class object, JsonValue jsonValue) {
        Object object2;
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.isObject()) {
            object2 = this.typeName == null ? null : jsonValue.getString(this.typeName, null);
            if (object2 != null && (clazz = this.getClass((String)object2)) == null) {
                try {
                    clazz = ClassReflection.forName((String)object2);
                }
                catch (ReflectionException reflectionException) {
                    throw new SerializationException(reflectionException);
                }
            }
            if (clazz == null) {
                if (this.defaultSerializer != null) {
                    return this.defaultSerializer.read(this, jsonValue, clazz);
                }
                return jsonValue;
            }
            if (this.typeName != null && ClassReflection.isAssignableFrom(Collection.class, clazz)) {
                if ((jsonValue = jsonValue.get("items")) == null) {
                    throw new SerializationException("Unable to convert object to collection: " + jsonValue + " (" + clazz.getName() + ")");
                }
            } else {
                Json$Serializer json$Serializer = (Json$Serializer)this.classToSerializer.get(clazz);
                if (json$Serializer != null) {
                    return json$Serializer.read(this, jsonValue, clazz);
                }
                if (clazz == String.class || clazz == Integer.class || clazz == Boolean.class || clazz == Float.class || clazz == Long.class || clazz == Double.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class || ClassReflection.isAssignableFrom(Enum.class, clazz)) {
                    return this.readValue("value", clazz, jsonValue);
                }
                Object object3 = this.newInstance(clazz);
                if (object3 instanceof Json$Serializable) {
                    ((Json$Serializable)object3).read(this, jsonValue);
                    return object3;
                }
                if (object3 instanceof ObjectMap) {
                    ObjectMap objectMap = (ObjectMap)object3;
                    JsonValue jsonValue2 = jsonValue.child;
                    while (jsonValue2 != null) {
                        objectMap.put(jsonValue2.name, this.readValue((Class)object, null, jsonValue2));
                        jsonValue2 = jsonValue2.next;
                    }
                    return objectMap;
                }
                if (object3 instanceof ObjectIntMap) {
                    ObjectIntMap objectIntMap = (ObjectIntMap)object3;
                    JsonValue jsonValue3 = jsonValue.child;
                    while (jsonValue3 != null) {
                        objectIntMap.put(jsonValue3.name, (Integer)this.readValue(Integer.class, null, jsonValue3));
                        jsonValue3 = jsonValue3.next;
                    }
                    return objectIntMap;
                }
                if (object3 instanceof ObjectFloatMap) {
                    ObjectFloatMap objectFloatMap = (ObjectFloatMap)object3;
                    JsonValue jsonValue4 = jsonValue.child;
                    while (jsonValue4 != null) {
                        objectFloatMap.put(jsonValue4.name, ((Float)this.readValue(Float.class, null, jsonValue4)).floatValue());
                        jsonValue4 = jsonValue4.next;
                    }
                    return objectFloatMap;
                }
                if (object3 instanceof ObjectSet) {
                    ObjectSet objectSet = (ObjectSet)object3;
                    JsonValue jsonValue5 = jsonValue.getChild("values");
                    while (jsonValue5 != null) {
                        objectSet.add(this.readValue((Class)object, null, jsonValue5));
                        jsonValue5 = jsonValue5.next;
                    }
                    return objectSet;
                }
                if (object3 instanceof IntMap) {
                    IntMap intMap = (IntMap)object3;
                    JsonValue jsonValue6 = jsonValue.child;
                    while (jsonValue6 != null) {
                        intMap.put(Integer.parseInt(jsonValue6.name), this.readValue((Class)object, null, jsonValue6));
                        jsonValue6 = jsonValue6.next;
                    }
                    return intMap;
                }
                if (object3 instanceof LongMap) {
                    LongMap longMap = (LongMap)object3;
                    JsonValue jsonValue7 = jsonValue.child;
                    while (jsonValue7 != null) {
                        longMap.put(Long.parseLong(jsonValue7.name), this.readValue((Class)object, null, jsonValue7));
                        jsonValue7 = jsonValue7.next;
                    }
                    return longMap;
                }
                if (object3 instanceof IntSet) {
                    IntSet intSet = (IntSet)object3;
                    JsonValue jsonValue8 = jsonValue.getChild("values");
                    while (jsonValue8 != null) {
                        intSet.add(jsonValue8.asInt());
                        jsonValue8 = jsonValue8.next;
                    }
                    return intSet;
                }
                if (object3 instanceof ArrayMap) {
                    ArrayMap arrayMap = (ArrayMap)object3;
                    JsonValue jsonValue9 = jsonValue.child;
                    while (jsonValue9 != null) {
                        arrayMap.put(jsonValue9.name, this.readValue((Class)object, null, jsonValue9));
                        jsonValue9 = jsonValue9.next;
                    }
                    return arrayMap;
                }
                if (object3 instanceof Map) {
                    Map map = (Map)object3;
                    JsonValue jsonValue10 = jsonValue.child;
                    while (jsonValue10 != null) {
                        if (!jsonValue10.name.equals(this.typeName)) {
                            map.put(jsonValue10.name, this.readValue((Class)object, null, jsonValue10));
                        }
                        jsonValue10 = jsonValue10.next;
                    }
                    return map;
                }
                this.readFields(object3, jsonValue);
                return object3;
            }
        }
        if (clazz != null) {
            object2 = (Json$Serializer)this.classToSerializer.get(clazz);
            if (object2 != null) {
                return object2.read(this, jsonValue, clazz);
            }
            if (ClassReflection.isAssignableFrom(Json$Serializable.class, clazz)) {
                Object object4 = this.newInstance(clazz);
                ((Json$Serializable)object4).read(this, jsonValue);
                return object4;
            }
        }
        if (jsonValue.isArray()) {
            if (clazz == null || clazz == Object.class) {
                clazz = Array.class;
            }
            if (ClassReflection.isAssignableFrom(Array.class, clazz)) {
                object2 = clazz == Array.class ? new Array() : (Array)this.newInstance(clazz);
                JsonValue jsonValue11 = jsonValue.child;
                while (jsonValue11 != null) {
                    ((Array)object2).add(this.readValue((Class)object, null, jsonValue11));
                    jsonValue11 = jsonValue11.next;
                }
                return object2;
            }
            if (ClassReflection.isAssignableFrom(Queue.class, clazz)) {
                object2 = clazz == Queue.class ? new Queue() : (Queue)this.newInstance(clazz);
                JsonValue jsonValue12 = jsonValue.child;
                while (jsonValue12 != null) {
                    ((Queue)object2).addLast(this.readValue((Class)object, null, jsonValue12));
                    jsonValue12 = jsonValue12.next;
                }
                return object2;
            }
            if (ClassReflection.isAssignableFrom(Collection.class, clazz)) {
                object2 = clazz.isInterface() ? new ArrayList() : (Collection)this.newInstance(clazz);
                JsonValue jsonValue13 = jsonValue.child;
                while (jsonValue13 != null) {
                    object2.add(this.readValue((Class)object, null, jsonValue13));
                    jsonValue13 = jsonValue13.next;
                }
                return object2;
            }
            if (clazz.isArray()) {
                object2 = clazz.getComponentType();
                if (object == null) {
                    object = object2;
                }
                Object object5 = ArrayReflection.newInstance((Class)object2, jsonValue.size);
                int n2 = 0;
                JsonValue jsonValue14 = jsonValue.child;
                while (jsonValue14 != null) {
                    ArrayReflection.set(object5, n2++, this.readValue((Class)object, null, jsonValue14));
                    jsonValue14 = jsonValue14.next;
                }
                return object5;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonValue + " (" + clazz.getName() + ")");
        }
        if (jsonValue.isNumber()) {
            try {
                if (clazz == null || clazz == Float.TYPE || clazz == Float.class) {
                    return Float.valueOf(jsonValue.asFloat());
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return jsonValue.asInt();
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return jsonValue.asLong();
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return jsonValue.asDouble();
                }
                if (clazz == String.class) {
                    return jsonValue.asString();
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return jsonValue.asShort();
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return jsonValue.asByte();
                }
                if (clazz == Character.TYPE || clazz == Character.class) {
                    return Character.valueOf(jsonValue.asChar());
                }
            }
            catch (NumberFormatException numberFormatException) {}
            jsonValue = new JsonValue(jsonValue.asString());
        }
        if (jsonValue.isBoolean()) {
            try {
                if (clazz == null || clazz == Boolean.TYPE || clazz == Boolean.class) {
                    return jsonValue.asBoolean();
                }
            }
            catch (NumberFormatException numberFormatException) {}
            jsonValue = new JsonValue(jsonValue.asString());
        }
        if (jsonValue.isString()) {
            object2 = jsonValue.asString();
            if (clazz == null || clazz == String.class) {
                return object2;
            }
            try {
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return Integer.valueOf(object2);
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return Float.valueOf((String)object2);
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return Long.valueOf((String)object2);
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return Double.valueOf((String)object2);
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return Short.valueOf((String)object2);
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return Byte.valueOf((String)object2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.valueOf((String)object2);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(((String)object2).charAt(0));
            }
            if (ClassReflection.isAssignableFrom(Enum.class, clazz)) {
                for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                    if (!((String)object2).equals(this.convertToString(enum_))) continue;
                    return enum_;
                }
            }
            if (clazz == CharSequence.class) {
                return object2;
            }
            throw new SerializationException("Unable to convert value to required type: " + jsonValue + " (" + clazz.getName() + ")");
        }
        return null;
    }

    public void copyFields(Object object, Object object2) {
        OrderedMap orderedMap = this.getFields(object2.getClass());
        for (ObjectMap$Entry objectMap$Entry : this.getFields(object.getClass())) {
            e e2 = (e)orderedMap.get((String)objectMap$Entry.key);
            Field field = ((e)objectMap$Entry.value).a;
            if (e2 == null) {
                throw new SerializationException("To object is missing field: " + (String)objectMap$Entry.key);
            }
            try {
                e2.a.set(object2, field.get(object));
            }
            catch (ReflectionException reflectionException) {
                throw new SerializationException("Error copying field: " + field.getName(), reflectionException);
            }
        }
    }

    private String convertToString(Enum enum_) {
        if (this.enumNames) {
            return enum_.name();
        }
        return enum_.toString();
    }

    private String convertToString(Object object) {
        if (object instanceof Enum) {
            return this.convertToString((Enum)object);
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    /*
     * WARNING - void declaration
     */
    protected Object newInstance(Class clazz) {
        try {
            return ClassReflection.newInstance(clazz);
        }
        catch (Exception exception) {
            void var2_4;
            try {
                Constructor constructor = ClassReflection.getDeclaredConstructor(clazz, new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (ReflectionException reflectionException) {
                if (ClassReflection.isAssignableFrom(Enum.class, clazz)) {
                    if (clazz.getEnumConstants() == null) {
                        clazz = clazz.getSuperclass();
                    }
                    return clazz.getEnumConstants()[0];
                }
                if (clazz.isArray()) {
                    throw new SerializationException("Encountered JSON object when expected array of type: " + clazz.getName(), exception);
                }
                if (ClassReflection.isMemberClass(clazz) && !ClassReflection.isStaticClass(clazz)) {
                    throw new SerializationException("Class cannot be created (non-static member class): " + clazz.getName(), exception);
                }
                throw new SerializationException("Class cannot be created (missing no-arg constructor): " + clazz.getName(), exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SerializationException("Error constructing instance of class: " + clazz.getName(), (Throwable)var2_4);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(String string) {
        return this.prettyPrint(string, 0);
    }

    public String prettyPrint(Object object, int n2) {
        Json json = this;
        return json.prettyPrint(json.toJson(object), n2);
    }

    public String prettyPrint(String string, int n2) {
        return this.reader.parse(string).prettyPrint(this.outputType, n2);
    }

    public String prettyPrint(Object object, JsonValue$PrettyPrintSettings jsonValue$PrettyPrintSettings) {
        Json json = this;
        return json.prettyPrint(json.toJson(object), jsonValue$PrettyPrintSettings);
    }

    public String prettyPrint(String string, JsonValue$PrettyPrintSettings jsonValue$PrettyPrintSettings) {
        return this.reader.parse(string).prettyPrint(jsonValue$PrettyPrintSettings);
    }
}

