/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntSet;
import java.util.NoSuchElementException;

public class IntSet$IntSetIterator {
    private static final int INDEX_ILLEGAL = -2;
    private static final int INDEX_ZERO = -1;
    public boolean hasNext;
    final IntSet set;
    int nextIndex;
    int currentIndex;
    boolean valid = true;

    public IntSet$IntSetIterator(IntSet intSet) {
        this.set = intSet;
        this.reset();
    }

    public void reset() {
        this.currentIndex = -2;
        this.nextIndex = -1;
        if (this.set.hasZeroValue) {
            this.hasNext = true;
            return;
        }
        this.findNextIndex();
    }

    void findNextIndex() {
        int[] nArray = this.set.keyTable;
        int n2 = this.set.keyTable.length;
        while (++this.nextIndex < n2) {
            if (nArray[this.nextIndex] == 0) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    public void remove() {
        int n2 = this.currentIndex;
        if (n2 == -1 && this.set.hasZeroValue) {
            this.set.hasZeroValue = false;
        } else {
            int n3;
            if (n2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            int[] nArray = this.set.keyTable;
            int n4 = this.set.mask;
            int n5 = n2 + 1 & n4;
            while ((n3 = nArray[n5]) != 0) {
                int n6 = this.set.place(n3);
                if ((n5 - n6 & n4) > (n2 - n6 & n4)) {
                    nArray[n2] = n3;
                    n2 = n5;
                }
                n5 = n5 + 1 & n4;
            }
            nArray[n2] = 0;
            if (n2 != this.currentIndex) {
                --this.nextIndex;
            }
        }
        this.currentIndex = -2;
        --this.set.size;
    }

    public int next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.valid) {
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }
        int n2 = this.nextIndex == -1 ? 0 : this.set.keyTable[this.nextIndex];
        this.currentIndex = this.nextIndex;
        this.findNextIndex();
        return n2;
    }

    public IntArray toArray() {
        IntArray intArray = new IntArray(true, this.set.size);
        while (this.hasNext) {
            intArray.add(this.next());
        }
        return intArray;
    }
}

