/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.IntMap$Entries;
import com.badlogic.gdx.utils.IntMap$Keys;
import com.badlogic.gdx.utils.IntMap$Values;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;
import java.util.Iterator;

public class IntMap
implements Iterable {
    public int size;
    int[] keyTable;
    Object[] valueTable;
    Object zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;
    private transient IntMap$Entries entries1;
    private transient IntMap$Entries entries2;
    private transient IntMap$Values values1;
    private transient IntMap$Values values2;
    private transient IntMap$Keys keys1;
    private transient IntMap$Keys keys2;

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int n2) {
        this(n2, 0.8f);
    }

    public IntMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: ".concat(String.valueOf(f2)));
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n2];
        this.valueTable = new Object[n2];
    }

    public IntMap(IntMap intMap) {
        this((int)((float)intMap.keyTable.length * intMap.loadFactor), intMap.loadFactor);
        System.arraycopy(intMap.keyTable, 0, this.keyTable, 0, intMap.keyTable.length);
        System.arraycopy(intMap.valueTable, 0, this.valueTable, 0, intMap.valueTable.length);
        this.size = intMap.size;
        this.zeroValue = intMap.zeroValue;
        this.hasZeroValue = intMap.hasZeroValue;
    }

    protected int place(int n2) {
        return (int)((long)n2 * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(int n2) {
        int[] nArray = this.keyTable;
        int n3 = this.place(n2);
        int n4;
        while ((n4 = nArray[n3]) != 0) {
            if (n4 == n2) {
                return n3;
            }
            n3 = n3 + 1 & this.mask;
        }
        return -(n3 + 1);
    }

    public Object put(int n2, Object object) {
        if (n2 == 0) {
            Object object2 = this.zeroValue;
            this.zeroValue = object;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return object2;
        }
        int n3 = this.locateKey(n2);
        if (n3 >= 0) {
            Object object3 = this.valueTable[n3];
            this.valueTable[n3] = object;
            return object3;
        }
        n3 = -(n3 + 1);
        this.keyTable[n3] = n2;
        this.valueTable[n3] = object;
        if (++this.size >= this.threshold) {
            IntMap intMap = this;
            intMap.resize(intMap.keyTable.length << 1);
        }
        return null;
    }

    public void putAll(IntMap objectArray) {
        this.ensureCapacity(objectArray.size);
        if (objectArray.hasZeroValue) {
            this.put(0, objectArray.zeroValue);
        }
        int[] nArray = objectArray.keyTable;
        objectArray = objectArray.valueTable;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) continue;
            this.put(n3, objectArray[i2]);
        }
    }

    private void putResize(int n2, Object object) {
        int[] nArray = this.keyTable;
        int n3 = this.place(n2);
        while (true) {
            if (nArray[n3] == 0) {
                nArray[n3] = n2;
                this.valueTable[n3] = object;
                return;
            }
            n3 = n3 + 1 & this.mask;
        }
    }

    public Object get(int n2) {
        if (n2 == 0) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return null;
        }
        if ((n2 = this.locateKey(n2)) >= 0) {
            return this.valueTable[n2];
        }
        return null;
    }

    public Object get(int n2, Object object) {
        if (n2 == 0) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return object;
        }
        if ((n2 = this.locateKey(n2)) >= 0) {
            return this.valueTable[n2];
        }
        return object;
    }

    public Object remove(int n2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            Object object = this.zeroValue;
            this.zeroValue = null;
            --this.size;
            return object;
        }
        int n3 = this.locateKey(n2);
        if (n3 < 0) {
            return null;
        }
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        Object object = this.valueTable[n3];
        int n4 = this.mask;
        int n5 = n3 + 1 & n4;
        while ((n2 = nArray[n5]) != 0) {
            int n6 = this.place(n2);
            if ((n5 - n6 & n4) > (n3 - n6 & n4)) {
                nArray[n3] = n2;
                objectArray[n3] = objectArray[n5];
                n3 = n5;
            }
            n5 = n5 + 1 & n4;
        }
        nArray[n3] = 0;
        objectArray[n3] = null;
        --this.size;
        return object;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object object, boolean n2) {
        Object[] objectArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] nArray = this.keyTable;
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                if (nArray[i2] == 0 || objectArray[i2] != null) continue;
                return true;
            }
        } else if (n2 != 0) {
            if (object == this.zeroValue) {
                return true;
            }
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                if (objectArray[n2] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(objectArray[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(n2) >= 0;
    }

    public int findKey(Object object, boolean n2, int n3) {
        Object[] objectArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] nArray = this.keyTable;
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                if (nArray[i2] == 0 || objectArray[i2] != null) continue;
                return nArray[i2];
            }
        } else if (n2 != 0) {
            if (object == this.zeroValue) {
                return 0;
            }
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                if (objectArray[n2] != object) continue;
                return this.keyTable[n2];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0;
            }
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                if (!object.equals(objectArray[n2])) continue;
                return this.keyTable[n2];
            }
        }
        return n3;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    private void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        this.keyTable = new int[n2];
        this.valueTable = new Object[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = nArray[n2];
                if (n4 == 0) continue;
                this.putResize(n4, objectArray[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        if (this.hasZeroValue && this.zeroValue != null) {
            n2 += this.zeroValue.hashCode();
        }
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 == 0) continue;
            n2 += n4 * 31;
            Object object = objectArray[i2];
            if (object == null) continue;
            n2 += object.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        object = (IntMap)object;
        if (((IntMap)object).size != this.size) {
            return false;
        }
        if (((IntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntMap)object).zeroValue == null ? this.zeroValue != null : !((IntMap)object).zeroValue.equals(this.zeroValue))) {
            return false;
        }
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            int n3 = nArray[i2];
            if (n3 == 0 || !((object2 = objectArray[i2]) == null ? ((IntMap)object).get(n3, ObjectMap.dummy) != null : !object2.equals(((IntMap)object).get(n3)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        object = (IntMap)object;
        if (((IntMap)object).size != this.size) {
            return false;
        }
        if (((IntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((IntMap)object).zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0 || objectArray[i2] == ((IntMap)object).get(n3, ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        Object[] objectArray = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(objectArray[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(objectArray[n3]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Iterator iterator() {
        return this.entries();
    }

    public IntMap$Entries entries() {
        if (Collections.allocateIterators) {
            return new IntMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new IntMap$Entries(this);
            this.entries2 = new IntMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public IntMap$Values values() {
        if (Collections.allocateIterators) {
            return new IntMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new IntMap$Values(this);
            this.values2 = new IntMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public IntMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new IntMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new IntMap$Keys(this);
            this.keys2 = new IntMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

