/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.IntIntMap$Entries;
import com.badlogic.gdx.utils.IntIntMap$Keys;
import com.badlogic.gdx.utils.IntIntMap$Values;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Arrays;
import java.util.Iterator;

public class IntIntMap
implements Iterable {
    public int size;
    int[] keyTable;
    int[] valueTable;
    int zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;
    private transient IntIntMap$Entries entries1;
    private transient IntIntMap$Entries entries2;
    private transient IntIntMap$Values values1;
    private transient IntIntMap$Values values2;
    private transient IntIntMap$Keys keys1;
    private transient IntIntMap$Keys keys2;

    public IntIntMap() {
        this(51, 0.8f);
    }

    public IntIntMap(int n2) {
        this(n2, 0.8f);
    }

    public IntIntMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: ".concat(String.valueOf(f2)));
        }
        this.loadFactor = f2;
        n2 = ObjectSet.tableSize(n2, f2);
        this.threshold = (int)((float)n2 * f2);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n2];
        this.valueTable = new int[n2];
    }

    public IntIntMap(IntIntMap intIntMap) {
        this((int)((float)intIntMap.keyTable.length * intIntMap.loadFactor), intIntMap.loadFactor);
        System.arraycopy(intIntMap.keyTable, 0, this.keyTable, 0, intIntMap.keyTable.length);
        System.arraycopy(intIntMap.valueTable, 0, this.valueTable, 0, intIntMap.valueTable.length);
        this.size = intIntMap.size;
        this.zeroValue = intIntMap.zeroValue;
        this.hasZeroValue = intIntMap.hasZeroValue;
    }

    protected int place(int n2) {
        return (int)((long)n2 * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(int n2) {
        int[] nArray = this.keyTable;
        int n3 = this.place(n2);
        int n4;
        while ((n4 = nArray[n3]) != 0) {
            if (n4 == n2) {
                return n3;
            }
            n3 = n3 + 1 & this.mask;
        }
        return -(n3 + 1);
    }

    public void put(int n2, int n3) {
        if (n2 == 0) {
            this.zeroValue = n3;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int n4 = this.locateKey(n2);
        if (n4 >= 0) {
            this.valueTable[n4] = n3;
            return;
        }
        n4 = -(n4 + 1);
        this.keyTable[n4] = n2;
        this.valueTable[n4] = n3;
        if (++this.size >= this.threshold) {
            IntIntMap intIntMap = this;
            intIntMap.resize(intIntMap.keyTable.length << 1);
        }
    }

    public int put(int n2, int n3, int n4) {
        if (n2 == 0) {
            int n5 = this.zeroValue;
            this.zeroValue = n3;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
                return n4;
            }
            return n5;
        }
        int n6 = this.locateKey(n2);
        if (n6 >= 0) {
            n2 = this.valueTable[n6];
            this.valueTable[n6] = n3;
            return n2;
        }
        n6 = -(n6 + 1);
        this.keyTable[n6] = n2;
        this.valueTable[n6] = n3;
        if (++this.size >= this.threshold) {
            IntIntMap intIntMap = this;
            intIntMap.resize(intIntMap.keyTable.length << 1);
        }
        return n4;
    }

    public void putAll(IntIntMap object) {
        this.ensureCapacity(((IntIntMap)object).size);
        if (((IntIntMap)object).hasZeroValue) {
            this.put(0, ((IntIntMap)object).zeroValue);
        }
        int[] nArray = ((IntIntMap)object).keyTable;
        object = ((IntIntMap)object).valueTable;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) continue;
            this.put(n3, (int)object[i2]);
        }
    }

    private void putResize(int n2, int n3) {
        int[] nArray = this.keyTable;
        int n4 = this.place(n2);
        while (true) {
            if (nArray[n4] == 0) {
                nArray[n4] = n2;
                this.valueTable[n4] = n3;
                return;
            }
            n4 = n4 + 1 & this.mask;
        }
    }

    public int get(int n2, int n3) {
        if (n2 == 0) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return n3;
        }
        if ((n2 = this.locateKey(n2)) >= 0) {
            return this.valueTable[n2];
        }
        return n3;
    }

    public int getAndIncrement(int n2, int n3, int n4) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                this.zeroValue = n3 + n4;
                ++this.size;
                return n3;
            }
            int n5 = this.zeroValue;
            this.zeroValue += n4;
            return n5;
        }
        int n6 = this.locateKey(n2);
        if (n6 >= 0) {
            n2 = this.valueTable[n6];
            int n7 = n6;
            this.valueTable[n7] = this.valueTable[n7] + n4;
            return n2;
        }
        n6 = -(n6 + 1);
        this.keyTable[n6] = n2;
        this.valueTable[n6] = n3 + n4;
        if (++this.size >= this.threshold) {
            IntIntMap intIntMap = this;
            intIntMap.resize(intIntMap.keyTable.length << 1);
        }
        return n3;
    }

    public int remove(int n2, int n3) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return n3;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int n4 = this.locateKey(n2);
        if (n4 < 0) {
            return n3;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n5 = this.valueTable[n4];
        int n6 = this.mask;
        int n7 = n4 + 1 & n6;
        while ((n2 = nArray[n7]) != 0) {
            int n8 = this.place(n2);
            if ((n7 - n8 & n6) > (n4 - n8 & n6)) {
                nArray[n4] = n2;
                nArray2[n4] = nArray2[n7];
                n4 = n7;
            }
            n7 = n7 + 1 & n6;
        }
        nArray[n4] = 0;
        --this.size;
        return n5;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(n2)));
        }
        if (this.keyTable.length > (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    public void clear(int n2) {
        if (this.keyTable.length <= (n2 = ObjectSet.tableSize(n2, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size = 0;
        this.hasZeroValue = false;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        Arrays.fill(this.keyTable, 0);
        this.size = 0;
        this.hasZeroValue = false;
    }

    public boolean containsValue(int n2) {
        if (this.hasZeroValue && this.zeroValue == n2) {
            return true;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            if (nArray[i2] == 0 || nArray2[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(n2) >= 0;
    }

    public int findKey(int n2, int n3) {
        if (this.hasZeroValue && this.zeroValue == n2) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        for (int i2 = this.valueTable.length - 1; i2 >= 0; --i2) {
            int n4 = nArray[i2];
            if (n4 == 0 || nArray2[i2] != n2) continue;
            return n4;
        }
        return n3;
    }

    public void ensureCapacity(int n2) {
        if (this.keyTable.length < (n2 = ObjectSet.tableSize(this.size + n2, this.loadFactor))) {
            this.resize(n2);
        }
    }

    private void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        this.keyTable = new int[n2];
        this.valueTable = new int[n2];
        if (this.size > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = nArray[n2];
                if (n4 == 0) continue;
                this.putResize(n4, nArray2[n2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        if (this.hasZeroValue) {
            n2 += this.zeroValue;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 == 0) continue;
            n2 += n4 * 31 + nArray2[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntIntMap)) {
            return false;
        }
        object = (IntIntMap)object;
        if (((IntIntMap)object).size != this.size) {
            return false;
        }
        if (((IntIntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && ((IntIntMap)object).zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) continue;
            int n4 = ((IntIntMap)object).get(n3, 0);
            if (n4 == 0 && !((IntIntMap)object).containsKey(n3)) {
                return false;
            }
            if (n4 == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(nArray2[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(nArray2[n3]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Iterator iterator() {
        return this.entries();
    }

    public IntIntMap$Entries entries() {
        if (Collections.allocateIterators) {
            return new IntIntMap$Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new IntIntMap$Entries(this);
            this.entries2 = new IntIntMap$Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public IntIntMap$Values values() {
        if (Collections.allocateIterators) {
            return new IntIntMap$Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new IntIntMap$Values(this);
            this.values2 = new IntIntMap$Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public IntIntMap$Keys keys() {
        if (Collections.allocateIterators) {
            return new IntIntMap$Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new IntIntMap$Keys(this);
            this.keys2 = new IntIntMap$Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }
}

