/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.d.a;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Keys;
import com.badlogic.gdx.utils.PropertiesUtils;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.ab;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public class I18NBundle {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static boolean simpleFormatter = false;
    private static boolean exceptionOnMissingKey = true;
    private I18NBundle parent;
    private Locale locale;
    private ObjectMap properties;
    private ab formatter;

    public static boolean getSimpleFormatter() {
        return simpleFormatter;
    }

    public static void setSimpleFormatter(boolean bl2) {
        simpleFormatter = bl2;
    }

    public static boolean getExceptionOnMissingKey() {
        return exceptionOnMissingKey;
    }

    public static void setExceptionOnMissingKey(boolean bl2) {
        exceptionOnMissingKey = bl2;
    }

    public static I18NBundle createBundle(a a2) {
        return I18NBundle.createBundleImpl(a2, Locale.getDefault(), DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(a a2, Locale locale) {
        return I18NBundle.createBundleImpl(a2, locale, DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(a a2, String string) {
        return I18NBundle.createBundleImpl(a2, Locale.getDefault(), string);
    }

    public static I18NBundle createBundle(a a2, Locale locale, String string) {
        return I18NBundle.createBundleImpl(a2, locale, string);
    }

    private static I18NBundle createBundleImpl(a a2, Locale locale, String string) {
        I18NBundle i18NBundle;
        if (a2 == null || locale == null || string == null) {
            throw new NullPointerException();
        }
        I18NBundle i18NBundle2 = null;
        Locale locale2 = locale;
        do {
            List list;
            if ((i18NBundle = I18NBundle.loadBundleChain(a2, string, list = I18NBundle.getCandidateLocales(locale2), 0, i18NBundle2)) == null) continue;
            Locale locale3 = i18NBundle.getLocale();
            if (!locale3.equals(Locale.ROOT) || locale3.equals(locale) || list.size() == 1 && locale3.equals(list.get(0))) break;
            if (i18NBundle2 != null) continue;
            i18NBundle2 = i18NBundle;
        } while ((locale2 = I18NBundle.getFallbackLocale(locale2)) != null);
        if (i18NBundle == null) {
            if (i18NBundle2 == null) {
                throw new MissingResourceException("Can't find bundle for base file handle " + a2.c() + ", locale " + locale, a2 + "_" + locale, "");
            }
            i18NBundle = i18NBundle2;
        }
        return i18NBundle;
    }

    private static List getCandidateLocales(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (!string3.isEmpty()) {
            arrayList.add(locale);
        }
        if (!string2.isEmpty()) {
            ArrayList<Locale> arrayList2 = arrayList;
            arrayList2.add(arrayList2.isEmpty() ? locale : new Locale(string, string2));
        }
        if (!string.isEmpty()) {
            ArrayList<Locale> arrayList3 = arrayList;
            arrayList3.add(arrayList3.isEmpty() ? locale : new Locale(string));
        }
        arrayList.add(Locale.ROOT);
        return arrayList;
    }

    private static Locale getFallbackLocale(Locale locale) {
        Locale locale2 = Locale.getDefault();
        if (locale.equals(locale2)) {
            return null;
        }
        return locale2;
    }

    private static I18NBundle loadBundleChain(a object, String string, List list, int n2, I18NBundle i18NBundle) {
        Locale locale = (Locale)list.get(n2);
        I18NBundle i18NBundle2 = null;
        if (n2 != list.size() - 1) {
            i18NBundle2 = I18NBundle.loadBundleChain((a)object, string, list, n2 + 1, i18NBundle);
        } else if (i18NBundle != null && locale.equals(Locale.ROOT)) {
            return i18NBundle;
        }
        object = I18NBundle.loadBundle((a)object, string, locale);
        if (object != null) {
            ((I18NBundle)object).parent = i18NBundle2;
            return object;
        }
        return i18NBundle2;
    }

    private static I18NBundle loadBundle(a a2, String string, Locale locale) {
        I18NBundle i18NBundle = null;
        Reader reader = null;
        try {
            a2 = I18NBundle.toFileHandle(a2, locale);
            if (I18NBundle.checkFileExistence(a2)) {
                i18NBundle = new I18NBundle();
                reader = a2.c(string);
                i18NBundle.load(reader);
            }
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException(iOException);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
        if (i18NBundle != null) {
            i18NBundle.setLocale(locale);
        }
        return i18NBundle;
    }

    private static boolean checkFileExistence(a a2) {
        try {
            a2.h().close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void load(Reader reader) {
        this.properties = new ObjectMap();
        PropertiesUtils.load(this.properties, reader);
    }

    private static a toFileHandle(a a2, Locale object) {
        StringBuilder stringBuilder = new StringBuilder(a2.d());
        if (!((Locale)object).equals(Locale.ROOT)) {
            String string = ((Locale)object).getLanguage();
            String string2 = ((Locale)object).getCountry();
            object = ((Locale)object).getVariant();
            if (!(string.isEmpty() && string2.isEmpty() && ((String)object).isEmpty())) {
                stringBuilder.append('_');
                if (!((String)object).isEmpty()) {
                    stringBuilder.append(string).append('_').append(string2).append('_').append((String)object);
                } else if (!string2.isEmpty()) {
                    stringBuilder.append(string).append('_').append(string2);
                } else {
                    stringBuilder.append(string);
                }
            }
        }
        return a2.b(stringBuilder.append(".properties").toString());
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
        this.formatter = new ab(locale, !simpleFormatter);
    }

    public String get(String string) {
        String string2 = (String)this.properties.get(string);
        if (string2 == null) {
            if (this.parent != null) {
                string2 = this.parent.get(string);
            }
            if (string2 == null) {
                if (exceptionOnMissingKey) {
                    throw new MissingResourceException("Can't find bundle key ".concat(String.valueOf(string)), this.getClass().getName(), string);
                }
                return "???" + string + "???";
            }
        }
        return string2;
    }

    public Set keys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ObjectMap$Keys objectMap$Keys = this.properties.keys();
        if (objectMap$Keys != null) {
            for (String string : objectMap$Keys) {
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    public String format(String string, Object ... objectArray) {
        return this.formatter.a(this.get(string), objectArray);
    }

    public void debug(String string) {
        ObjectMap$Keys objectMap$Keys = this.properties.keys();
        if (objectMap$Keys == null) {
            return;
        }
        for (String string2 : objectMap$Keys) {
            this.properties.put(string2, string);
        }
    }
}

